<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AboutFeature;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Traits\ImageHandler;

class AboutFeatureController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $aboutFeatures = AboutFeature::latest()->get();
        return view('admin.about-features.index', compact('aboutFeatures'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('admin.about-features.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string|max:255',
            'image' => 'nullable|image|max:10240',
            'icon' => 'required|string|max:255',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {
            $data['image'] = $this->processImage($request->file('image'), 'uploads/about-features');
        }

        if ($request->hasFile('icon')) {
            $data['icon'] = $this->processImage($request->file('icon'), 'uploads/about-features');
        }

        AboutFeature::create($data);

        return redirect()->route('admin.about-features.index')
            ->with('success', 'About Feature created successfully.');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $aboutFeature = AboutFeature::find($id);
        $row = $aboutFeature;
        return view('admin.about-features.edit', compact('row'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $aboutFeature = AboutFeature::find($id);
        $aboutFeature->update([
            'title' => $request->title,
            'count' => $request->count,
        ]);

        return redirect()->route('admin.about-features.index')
            ->with('success', 'About Feature updated successfully.');
    }

    /**
     * Remove the specified resource from storage (soft delete).
     */
    public function destroy($id)
    {
        $aboutFeature = AboutFeature::find($id);
        $aboutFeature->update(['is_active' => 0]);

        return redirect()->route('admin.about-features.index')
            ->with('success', 'About Feature deactivated successfully.');
    }

    public function activate($id) {
        $aboutFeature = AboutFeature::find($id);
        $aboutFeature->update(['is_active' => 1]);

        return redirect()->route('admin.about-features.index')
            ->with('success', 'About Feature activated successfully.');
    }
}
