<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AboutHistory;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Traits\ImageHandler;

class AboutHistoryController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index()
    {
        $row = AboutHistory::first();
        if (!$row) {
            $row = AboutHistory::create([
                'title' => '',
                'description' => '',
                'image' => '',
            ]);
        }
        return view('admin.about-history.edit', compact('row'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
            'image' => 'nullable|image|max:10240', // 10MB
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {   
                $data['image'] = $this->processImage(
                    $request->file('image'),
                    'uploads/about-history'
            );
        }

       

        $row->update($data);

        return redirect()->route('admin.about-history.index')->with('success', 'About History updated successfully.');
    }
}
