<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AboutWhySection; 
use Illuminate\Http\Request;

class AboutWhySectionController extends Controller
{

    public function index()
    {
        $row = AboutWhySection::first();
        if (!$row) {
            $row = AboutWhySection::create([
                'title' => '',
                'description' => '',
            ]);
        }
        return view('admin.about-why-section.edit', compact('row'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
        ]);

        $data = $request->all();

        $row->update($data);

        return redirect()->route('admin.about-why-section.index')->with('success', 'About Why Section updated successfully.');
    }
}
