<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\CallToAction;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Traits\ImageHandler;

class CallToActionController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index()
    {
        $row = CallToAction::first();
        if (!$row) {
            $row = CallToAction::create([
                'title' => '',
                'description' => '',
                'image' => '',
            ]);
        }
        return view('admin.call-to-action.edit', compact('row'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
            'image' => 'nullable|image|max:10240', // 10MB
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {   
                $data['image'] = $this->processImage(
                    $request->file('image'),
                    'uploads/call-to-action'
            );
        }

        $row->update($data);

        return redirect()->route('admin.call-to-action.index')->with('success', 'Call To Action updated successfully.');
    }
}
