<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ContactInformation;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Traits\ImageHandler;

class ContactInformationController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }


    public function index()
    {
        $row = ContactInformation::first();
        if (!$row) {
            $row = ContactInformation::create([
                'footer_text' => '',
                'address' => '',
                'map_link' => '',
                'phone' => '',
                'email' => '',
                'whatsapp' => '',
                'main_logo' => '',
                'footer_logo' => '',
                'icon_logo' => '',
            ]);
        }
        return view('admin.contact-information.edit', compact('row'));
    }

    public function editSocialLink($id)
    {
         $row = ContactInformation::find($id);
         return view('admin.contact-information.edit-social-links', compact('row'));
    }

    public function update(Request $request, $id)
    {
        $contactInformation = ContactInformation::findOrFail($id);
        $data = $request->all();
        if ($request->hasFile('main_logo')) {
            $data['main_logo'] = $this->processImage($request->file('main_logo'), 'uploads/contact-information');
        }
        if ($request->hasFile('footer_logo')) {
            $data['footer_logo'] = $this->processImage($request->file('footer_logo'), 'uploads/contact-information');
        }
        if ($request->hasFile('icon_logo')) {
            $data['icon_logo'] = $this->processImage($request->file('icon_logo'), 'uploads/contact-information');
        }

        $contactInformation->update($data);
        
        return redirect()->route('admin.contact-information.index')->with('success', 'Contact Information updated successfully');
    }
}
