<?php

namespace App\Http\Controllers;

use App\Models\Blog;
use App\Models\Category;
use App\Models\Project;
use App\Models\ContactForm;
class DashboardController 
{
    public function index() 
    {
        $blogs = Blog::count();
        $projects = Project::count();
        $categories = Category::count();

        $latestBlogs = Blog::latest()->limit(4)->get();
        $latestProjects = Project::latest()->limit(4)->get();
        return view('admin.dashboard', compact( 
            'blogs', 
            'categories', 
            'latestBlogs',
            'projects',
            'categories',
            'latestProjects',
        ));
    }



}
