<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Feature;
use App\Services\ImageService;
use App\Traits\ImageHandler;
use Illuminate\Http\Request;

class FeatureController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index()
    {
        $features = Feature::latest()->paginate(10);
        return view('admin.features.index', compact('features'));
    }

    public function create()
    {
        return view('admin.features.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'text' => 'required|string',
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {
       
                $data['image'] = $this->processImage($request->file('image'), 'uploads/features');
          
        }

        Feature::create($data);

        return redirect()->route('admin.features.index')->with('success', 'Feature created successfully.');
    }

    public function edit($id)
    {
        $row = Feature::find($id);
        return view('admin.features.edit', compact('row'));
    }

    public function update(Request $request, $id)
    {
        $feature = Feature::find($id);
        if (!$feature) {
            return redirect()->route('admin.features.index')->with('error', 'Feature not found.');
        }
        $request->validate([
            'title' => 'required|string|max:255',
            'text' => 'required|string',
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {
          
                $this->imageService->deleteImage($feature->image);
                $data['image'] = $this->processImage($request->file('image'), 'uploads/features');
           
        }

        $feature->update($data);

        return redirect()->route('admin.features.index')->with('success', 'Feature updated successfully.');
    }

    public function destroy($id)
    {
        $feature = Feature::find($id);
        $feature->update(['is_active' => 0]);
        return redirect()->route('admin.features.index')->with('success', 'Feature deleted successfully.');
    }

    public function activate($id)
    {
        $feature = Feature::find($id);
        $feature->update(['is_active' => 1]);
        return redirect()->route('admin.features.index')->with('success', 'Feature activated successfully.');
    }
}
