<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\HeroSection;
use Illuminate\Http\Request;
use App\Services\ImageService;
use App\Traits\ImageHandler;

class HeroSectionController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index()
    {
        $row = HeroSection::first();
        if (!$row) {
            $row = HeroSection::create([
                'small_title' => '',
                'title' => '',
                'description' => '',
                'image' => '',
            ]);
        }
        return view('admin.hero-section.edit', compact('row'));
    }

    public function update(Request $request)
    {
        $request->validate([
            'small_title' => 'required|string|max:255',
            'title' => 'required|string|max:255',
            'description' => 'nullable|string|max:255',
            'image' => 'nullable|image|max:10240', // 10MB
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {   
                $data['image'] = $this->processImage(
                    $request->file('image'),
                    'uploads/hero-section'
            );
        }

        $row->update($data);

        return redirect()->route('admin.hero-section.index')->with('success', 'Hero Section updated successfully.');
    }
}
