<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProjectImage;
use App\Models\Project;
use App\Services\ImageService;
use App\Traits\ImageHandler;
use Illuminate\Http\Request;

class ProjectImageController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index($id)
    {
        $projectImages = ProjectImage::where('project_id', $id)->latest()->get();
        return view('admin.project-images.index', compact('projectImages'));
    }

    public function create($id)
    {
        $project = Project::find($id);
        return view('admin.project-images.create', compact('project'));
    }

    public function store(Request $request, $id)
    {
        $request->validate([
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);
        $data = $request->all();

        $data['project_id'] = $id;


        foreach ($request->file('image') as $image) {
            $data['image'] = $this->processImage($image, 'uploads/project-images');
            ProjectImage::create($data);
        }

        return redirect()->route('admin.project-images.index', $id)->with('success', 'Project image created successfully.');
    }

    public function edit($id)
    {
        $row = ProjectImage::find($id);
        $project = Project::find($row->project_id);
        return view('admin.project-images.edit', compact('row', 'project'));
    }

    public function update(Request $request, $id)
    {
        $projectImage = ProjectImage::find($id);
       
        $request->validate([
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {
          
                $this->imageService->deleteImage($projectImage->image);
                $data['image'] = $this->processImage($request->file('image'), 'uploads/project-images');
           
        }

        $projectImage->update($data);

        return redirect()->route('admin.project-images.index', $projectImage->project_id)->with('success', 'Project image updated successfully.');
    }

    public function destroy($id)
    {
        $projectImage = ProjectImage::find($id);
        $projectImage->update(['is_active' => 0]);
        return redirect()->route('admin.project-images.index', $projectImage->project_id)->with('success', 'Project image deleted successfully.');
    }

    public function activate($id)
    {
        $projectImage = ProjectImage::find($id);
        $projectImage->update(['is_active' => 1]);
        return redirect()->route('admin.project-images.index', $projectImage->project_id)->with('success', 'Project image activated successfully.');
    }

}
