<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\ProjectSector;
use App\Models\Project;
use App\Services\ImageService;
use App\Traits\ImageHandler;
use Illuminate\Http\Request;

class ProjectSectorController extends Controller
{
    use ImageHandler;
    protected $imageService;

    public function __construct(ImageService $imageService)
    {
        $this->imageService = $imageService;
    }

    public function index($id)
    {
        $projectSectors = ProjectSector::where('project_id', $id)->latest()->get();
        return view('admin.project-sectors.index', compact('projectSectors'));
    }

    public function create($id)
    {
        $project = Project::find($id);
        return view('admin.project-sectors.create', compact('project'));
    }

    public function store(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'nullable|string',
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);
        $data = $request->all();

        $data['project_id'] = $id;

        if ($request->hasFile('image')) {
            $data['image'] = $this->processImage($request->file('image'), 'uploads/project-sectors');
        }



        return redirect()->route('admin.project-sectors.index', $id)->with('success', 'Project sector created successfully.');
    }

    public function edit($id)
    {
        $row = ProjectSector::find($id);
        $project = Project::find($row->project_id);
        return view('admin.project-sectors.edit', compact('row', 'project'));
    }

    public function update(Request $request, $id)
    {
        $projectSector = ProjectSector::find($id);
       
        $request->validate([
            'image' => 'nullable|image|max:10240',
            'is_active' => 'boolean',
        ]);

        $data = $request->all();

        if ($request->hasFile('image')) {
          
                $this->imageService->deleteImage($projectSector->image);
                $data['image'] = $this->processImage($request->file('image'), 'uploads/project-sectors');
           
        }

        $projectSector->update($data);

        return redirect()->route('admin.project-sectors.index', $projectSector->project_id)->with('success', 'Project sector updated successfully.');
    }

    public function destroy($id)
    {
        $projectSector = ProjectSector::find($id);
        $projectSector->update(['is_active' => 0]);
        return redirect()->route('admin.project-sectors.index', $projectSector->project_id)->with('success', 'Project sector deleted successfully.');
    }

    public function activate($id)
    {
        $projectSector = ProjectSector::find($id);
        $projectSector->update(['is_active' => 1]);
        return redirect()->route('admin.project-sectors.index', $projectSector->project_id)->with('success', 'Project sector activated successfully.');
    }

}
