<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $table = 'projects';
    protected $fillable = [
        'category_id',
        'title',
        'slug',
        'description',
        'image',
        'project_url',
        'is_active',
        'meta_title',
        'meta_description',
        'page_schema',
        'is_active',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function images()
    {
        return $this->hasMany(ProjectImage::class);
    }

    public function sectors()
    {
        return $this->belongsToMany(ProjectSector::class);
    }
}
