<?php

namespace App\Traits;

use Illuminate\Support\Str;

trait FileHandler
{
    /**
     * Upload any file (PDF, DOC, DOCX, ZIP, MP4 ...)
     *
     * @param \Illuminate\Http\UploadedFile $file
     * @param string $baseFolder
     * @return string Full URL to file
     */
    public function uploadFile($file, $baseFolder)
    {
        $extension = strtolower($file->getClientOriginalExtension());

        // اسم الملف
        $fileName = Str::random(20) . '.' . $extension;

        // المسار
        $dir = public_path($baseFolder);

        // إنشاء المجلد إذا غير موجود
        if (!file_exists($dir)) {
            mkdir($dir, 0755, true);
        }

        // نقل الملف
        $file->move($dir, $fileName);

        // المسار النسبي
        $relativePath = "$baseFolder/$fileName";

        // إرجاع URL كامل
        return url($relativePath);
    }
}
