<?php

namespace App\Traits;

use Illuminate\Support\Str;

trait ImageHandler
{
    public function processImage($file, $baseFolder)
    {
        $extension = strtolower($file->getClientOriginalExtension());

        // --------------------------
        // GIF → Save original only
        // --------------------------
        if ($extension === 'gif') {

            $fileName = Str::random(20) . '.gif';

            $dir = public_path("$baseFolder/main");
            if (!file_exists($dir)) {
                mkdir($dir, 0755, true);
            }

            $relativePath = "$baseFolder/main/$fileName";
            $file->move($dir, $fileName);

            return url($relativePath);
        }

        // --------------------------
        // JPG / PNG / WEBP → Convert to WebP (NO RESIZE)
        // --------------------------

        $fileName = Str::random(20) . '.webp';

        $dir = public_path("$baseFolder/main");
        if (!file_exists($dir)) {
            mkdir($dir, 0755, true);
        }

        $relativePath = "$baseFolder/main/$fileName";

        // Create image from uploaded file
        // Create image from uploaded file
        $original = imagecreatefromstring(
            file_get_contents($file->getPathname())
        );

        if (!$original) {
            throw new \Exception("Invalid image format");
        }

        // ✅ لو الصورة Palette نحولها TrueColor
        if (!imageistruecolor($original)) {
            $trueColor = imagecreatetruecolor(
                imagesx($original),
                imagesy($original)
            );

            imagealphablending($trueColor, false);
            imagesavealpha($trueColor, true);

            imagecopy(
                $trueColor,
                $original,
                0,
                0,
                0,
                0,
                imagesx($original),
                imagesy($original)
            );

            imagedestroy($original);
            $original = $trueColor;
        }

        // Preserve transparency
        imagealphablending($original, false);
        imagesavealpha($original, true);

        // Save as WebP
        imagewebp($original, public_path($relativePath), 65);

        imagedestroy($original);


        return url($relativePath);
    }
}
