<?php

namespace App\Traits;

trait SlugGenrate
{
    /**
     * Generate slug from any title (Arabic + English supported)
     */
    public function makeSlug($title)
    {
        // 1) تحويل العنوان لـ lowercase بدون التأثير على العربي
        $title = mb_strtolower($title, 'UTF-8');

        // 2) استبدال أي رموز أو فواصل بمسافة
        $title = preg_replace('/[^\p{L}\p{N}]+/u', '-', $title);

        // 3) حذف أي - مكررة
        $title = preg_replace('/-+/', '-', $title);

        // 4) إزالة - من البداية والنهاية
        $title = trim($title, '-');

        return $title;
    }
}
