@extends('layouts.app')

@section('title', 'Create About Feature')

@section('content')


    <style>
        .page-titles .breadcrumb .breadcrumb-item+.breadcrumb-item::before {
            display: none;
        }


        .upload-box {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.3s;
            position: relative;
        }

        .upload-area:hover {
            border-color: #3b82f6;
            background: #f8fafc;
        }

        .upload-placeholder i {
            font-size: 40px;
            color: #3b82f6;
            margin-bottom: 10px;
        }

        .upload-placeholder p {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .upload-placeholder span {
            font-size: 12px;
            color: #6b7280;
        }

        .preview-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            display: none;
        }

        .upload-actions {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .upload-actions button {
            padding: 6px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-change {
            background: #3b82f6;
            color: white;
        }

        .btn-remove {
            background: #ef4444;
            color: white;
        }
    </style>

    <div class="content-body">
        <div class="container-fluid">

            <div class="row page-titles">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route('admin.dashboard') }}">Dashboard | </a></li>
                    <li class="breadcrumb-item active"><a href="{{ route('about-feature.index') }}">About Features > </a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Create</a></li>
                </ol>
            </div>


            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="">

                                        <div class="compose-content">
                                            <form action="{{ route('about-feature.store') }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf

   
                                                <div class="mb-3">
                                                    <label for="title">Title</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Title:" name="title" value="{{ old('title') }}" >
                                                </div>    

                                                <div class="mb-3">
                                                    <label for="description">Description</label>
                                                    <textarea class="form-control bg-transparent" name="description" rows="3" placeholder="Description:">{{ old('description') }}</textarea>
                                                </div>    

                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="image" id="imageInput" accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('imageInput').click()">
                                                            <div class="upload-placeholder" id="placeholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload image</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                        </div>

                                                        <div class="upload-actions" id="actions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeImage()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeImage()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Icon</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="icon" id="iconInput" accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('iconInput').click()">
                                                            <div class="upload-placeholder" id="placeholderIcon">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload icon</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            <img id="previewIcon" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 3.png') }}" />
                                                        </div>

                                                        <div class="upload-actions" id="actionsIcon" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeIcon()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeIcon()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>

                                                

                                                <div class="mb-3">
                                                    <label for="is_active">Active</label>
                                                    <select class="form-control bg-transparent" name="is_active">
                                                        <option value="1">Active</option>
                                                        <option value="0">Inactive</option>
                                                    </select>
                                                </div>    


                                                <div class="text-start mt-4 mb-3">
                                                    <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span
                                                            class="me-2"><i
                                                                class="fa fa-paper-plane"></i></span>Submit</button>

                                                    <a href="{{ route('about-feature.index') }}"
                                                        class="btn btn-danger light btn-sl-sm">
                                                        <span class="me-2"><i class="fa fa-times"></i></span>Discard
                                                    </a>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
		const input = document.getElementById('imageInput');
		const preview = document.getElementById('previewImage');
		const placeholder = document.getElementById('placeholder');
		const actions = document.getElementById('actions');

		input.addEventListener('change', function () {
			const file = this.files[0];

			if (file) {
				const reader = new FileReader();

				reader.onload = function (e) {
					preview.src = e.target.result;
					preview.style.display = 'block';
					placeholder.style.display = 'none';
					actions.style.display = 'flex';
				}

				reader.readAsDataURL(file);
			}
		});

		function changeImage() {
			input.click();
		}

		function removeImage() {
			input.value = '';
			preview.src = '';
			preview.style.display = 'none';
			placeholder.style.display = 'block';
			actions.style.display = 'none';
		}

	</script>

    <script>
        const inputIcon = document.getElementById('iconInput');
        const previewIcon = document.getElementById('previewIcon');
        const placeholderIcon = document.getElementById('placeholderIcon');
        const actionsIcon = document.getElementById('actionsIcon');

        inputIcon.addEventListener('change', function () {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function (e) {
                    previewIcon.src = e.target.result;
                    previewIcon.style.display = 'block';
                    placeholderIcon.style.display = 'none';
                    actionsIcon.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeIcon() {
            inputIcon.click();
        }

        function removeIcon() {
            inputIcon.value = '';
            previewIcon.src = '';
            previewIcon.style.display = 'none';
            placeholderIcon.style.display = 'block';
            actionsIcon.style.display = 'none';
        }

    </script>
@endsection
