@extends('admin.layouts.app')

@section('title', 'Edit Social Links')

@section('content')


    <style>
        .page-titles .breadcrumb .breadcrumb-item+.breadcrumb-item::before {
            display: none;
        }


        .upload-box {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.3s;
            position: relative;
        }

        .upload-area:hover {
            border-color: #3b82f6;
            background: #f8fafc;
        }

        .upload-placeholder i {
            font-size: 40px;
            color: #3b82f6;
            margin-bottom: 10px;
        }

        .upload-placeholder p {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .upload-placeholder span {
            font-size: 12px;
            color: #6b7280;
        }

        .preview-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            display: none;
        }

        .upload-actions {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .upload-actions button {
            padding: 6px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-change {
            background: #3b82f6;
            color: white;
        }

        .btn-remove {
            background: #ef4444;
            color: white;
        }
    </style>

    <div class="content-body">
        <div class="container-fluid">

            <div class="row page-titles">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route('dashboard') }}">Dashboard | </a></li>
                    <li class="breadcrumb-item active"><a href="{{ route('contact-information-editsite' , 1) }}">Contact Information > </a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Edit</a></li>
                </ol>
            </div>


            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="">
                                        @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                        @endif

                                        <div class="compose-content">
                                            <form action="{{ route('contact-information-updatesocial', 1) }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('POST')
`

                                                <div class="mb-3">
                                                    <label for="facebook_url">Facebook URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Facebook URL:" name="facebook_url" value="{{ $row->facebook_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="instagram_url">Instagram URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Instagram URL:" name="instagram_url" value="{{ $row->instagram_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="twitter_url">Twitter URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Twitter URL:" name="twitter_url" value="{{ $row->twitter_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="linkedin_url">LinkedIn URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="LinkedIn URL:" name="linkedin_url" value="{{ $row->linkedin_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="youtube_url">YouTube URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="YouTube URL:" name="youtube_url" value="{{ $row->youtube_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="tiktok_url">TikTok URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="TikTok URL:" name="tiktok_url" value="{{ $row->tiktok_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="snapchat_url">Snapchat URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Snapchat URL:" name="snapchat_url" value="{{ $row->snapchat_url }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="telegram_url">Telegram URL</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Telegram URL:" name="telegram_url" value="{{ $row->telegram_url }}">
                                                </div>

                                                <div class="text-start mt-4 mb-3">
                                                    <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span
                                                            class="me-2"><i
                                                                class="fa fa-paper-plane"></i></span>Submit</button>

                                                    <a href="{{ route('contact-information-social', 1) }}"
                                                        class="btn btn-danger light btn-sl-sm">
                                                        <span class="me-2"><i class="fa fa-times"></i></span>Discard
                                                    </a>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        const input = document.getElementById('imageInput');
        const preview = document.getElementById('previewImage');
        const placeholder = document.getElementById('placeholder');
        const actions = document.getElementById('actions');

        input.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    placeholder.style.display = 'none';
                    actions.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImage() {
            input.click();
        }

        function removeImage() {
            input.value = '';
            preview.src = '';
            preview.style.display = 'none';
            placeholder.style.display = 'block';
            actions.style.display = 'none';
        }
    </script>

    <script>
        const inputEN = document.getElementById('imageInputEN');
        const previewEN = document.getElementById('previewImageEN');
        const placeholderEN = document.getElementById('placeholderEN');
        const actionsEN = document.getElementById('actionsEN');

        inputEN.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    previewEN.src = e.target.result;
                    previewEN.style.display = 'block';
                    placeholderEN.style.display = 'none';
                    actionsEN.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImageEN() {
            inputEN.click();
        }

        function removeImageEN() {
            inputEN.value = '';
            previewEN.src = '';
            previewEN.style.display = 'none';
            placeholderEN.style.display = 'block';
            actionsEN.style.display = 'none';
        }
    </script>
@endsection
