@extends('admin.layouts.app')

@section('title', 'Edit Contact Information')

@section('content')


    <style>
        .page-titles .breadcrumb .breadcrumb-item+.breadcrumb-item::before {
            display: none;
        }


        .upload-box {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.3s;
            position: relative;
        }

        .upload-area:hover {
            border-color: #3b82f6;
            background: #f8fafc;
        }

        .upload-placeholder i {
            font-size: 40px;
            color: #3b82f6;
            margin-bottom: 10px;
        }

        .upload-placeholder p {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .upload-placeholder span {
            font-size: 12px;
            color: #6b7280;
        }

        .preview-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            display: none;
        }

        .upload-actions {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .upload-actions button {
            padding: 6px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-change {
            background: #3b82f6;
            color: white;
        }

        .btn-remove {
            background: #ef4444;
            color: white;
        }
    </style>

    <div class="content-body">
        <div class="container-fluid">

            <div class="row page-titles">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route('admin.dashboard') }}">Dashboard | </a></li>
                    <li class="breadcrumb-item active"><a href="{{ route('admin.contact-informations.index') }}">Contact Information > </a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Edit</a></li>
                </ol>
            </div>


            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="">
                                        @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                        @endif

                                        <div class="compose-content">
                                            <form action="{{ route('admin.contact-informations.update', $row->id) }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PUT')


                                                <div class="mb-3">
                                                    <label for="footer_text">Footer Text</label>
                                                    <input type="text" class="form-control bg-transparent" name="footer_text"
                                                        value="{{ $row->footer_text }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="address">Address</label>
                                                    <input type="text" class="form-control bg-transparent" name="address"
                                                        value="{{ $row->address }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="map_link">Map Link</label>
                                                    <input type="text" class="form-control bg-transparent" name="map_link"
                                                        value="{{ $row->map_link }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="phone">Phone</label>
                                                    <input type="text" class="form-control bg-transparent" name="phone"
                                                        value="{{ $row->phone }}">
                                                </div>


                                                <div class="mb-3">
                                                    <label for="whatsapp">Whatsapp</label>
                                                    <input type="text" class="form-control bg-transparent" name="whatsapp"
                                                        value="{{ $row->whatsapp }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="email">Email</label>
                                                    <input type="email" class="form-control bg-transparent" name="email"
                                                        value="{{ $row->email }}">
                                                </div>

                                                
                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i>Current Main Logo</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <div class="upload-area" style="cursor: default;">
                                                            @if ($row->main_logo)
                                                                <img id="" width="200" class=""
                                                                    src="{{ $row->main_logo }}" />
                                                            @else
                                                                <img id="" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="main_logo" id="imageInput"
                                                            accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('imageInput').click()">
                                                            <div class="upload-placeholder" id="placeholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload image</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            @if ($row->main_logo)
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ $row->main_logo }}" />
                                                            @else
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                            @endif
                                                        </div>

                                                        <div class="upload-actions" id="actions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeImage()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeImage()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i>Current Footer Logo</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <div class="upload-area" style="cursor: default;">
                                                            @if ($row->footer_logo)
                                                                <img id="" width="200" class=""
                                                                    src="{{ $row->footer_logo }}" />
                                                            @else
                                                                <img id="" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="footer_logo" id="footerLogoInput"
                                                            accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('footerLogoInput').click()">
                                                            <div class="upload-placeholder" id="footerLogoPlaceholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload footer logo</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            @if ($row->footer_logo)
                                                                <img id="previewFooterLogo" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ $row->footer_logo }}" />
                                                            @else
                                                                <img id="previewFooterLogo" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                            @endif
                                                        </div>

                                                        <div class="upload-actions" id="footerLogoActions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeFooterLogo()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeFooterLogo()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i>Current Icon Logo</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <div class="upload-area" style="cursor: default;">
                                                            @if ($row->icon_logo)
                                                                <img id="" width="200" class=""
                                                                    src="{{ $row->icon_logo }}" />
                                                            @else
                                                                <img id="" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="icon_logo" id="iconLogoInput"
                                                            accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('iconLogoInput').click()">
                                                            <div class="upload-placeholder" id="iconLogoPlaceholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload icon logo</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            @if ($row->icon_logo)
                                                                <img id="previewIconLogo" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ $row->icon_logo }}" />
                                                            @else
                                                                <img id="previewIconLogo" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                            @endif
                                                        </div>

                                                        <div class="upload-actions" id="iconLogoActions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeIconLogo()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeIconLogo()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>

                                                <div class="text-start mt-4 mb-3">
                                                    <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span
                                                            class="me-2"><i
                                                                class="fa fa-paper-plane"></i></span>Submit</button>

                                                    <a href="{{ route('admin.contact-informations.index') }}"
                                                        class="btn btn-danger light btn-sl-sm">
                                                        <span class="me-2"><i class="fa fa-times"></i></span>Discard
                                                    </a>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        const input = document.getElementById('imageInput');
        const preview = document.getElementById('previewImage');
        const placeholder = document.getElementById('placeholder');
        const actions = document.getElementById('actions');

        input.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    placeholder.style.display = 'none';
                    actions.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImage() {
            input.click();
        }

        function removeImage() {
            input.value = '';
            preview.src = '';
            preview.style.display = 'none';
            placeholder.style.display = 'block';
            actions.style.display = 'none';
        }
    </script>

    <script>
        const inputFooterLogo = document.getElementById('footerLogoInput');
        const previewFooterLogo = document.getElementById('previewFooterLogo');
        const placeholderFooterLogo = document.getElementById('placeholderFooterLogo');
        const actionsFooterLogo = document.getElementById('actionsFooterLogo');

        inputFooterLogo.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    previewFooterLogo.src = e.target.result;
                    previewFooterLogo.style.display = 'block';
                    placeholderFooterLogo.style.display = 'none';
                    actionsFooterLogo.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeFooterLogo() {
            inputFooterLogo.click();
        }

        function removeFooterLogo() {
            inputFooterLogo.value = '';
            previewFooterLogo.src = '';
            previewFooterLogo.style.display = 'none';
            placeholderFooterLogo.style.display = 'block';
            actionsFooterLogo.style.display = 'none';
        }
    </script>

<script>
    const inputIconLogo = document.getElementById('iconLogoInput');
    const previewIconLogo = document.getElementById('previewIconLogo');
    const placeholderIconLogo = document.getElementById('placeholderIconLogo');
    const actionsIconLogo = document.getElementById('actionsIconLogo');

    inputIconLogo.addEventListener('change', function() {
        const file = this.files[0];

        if (file) {
            const reader = new FileReader();

            reader.onload = function(e) {
                previewIconLogo.src = e.target.result;
                previewIconLogo.style.display = 'block';
                placeholderIconLogo.style.display = 'none';
                actionsIconLogo.style.display = 'flex';
            }

            reader.readAsDataURL(file);
        }
    });

    function changeIconLogo() {
        inputIconLogo.click();
    }

    function removeIconLogo() {
        inputIconLogo.value = '';
        previewIconLogo.src = '';
        previewIconLogo.style.display = 'none';
        placeholderIconLogo.style.display = 'block';
        actionsIconLogo.style.display = 'none';
    }
</script>
@endsection
