@extends('admin.layouts.app')

@section('title', $row->title . ' Page Information')

@section('content')


    <style>
        .page-titles .breadcrumb .breadcrumb-item+.breadcrumb-item::before {
            display: none;
        }


        .upload-box {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.3s;
            position: relative;
        }

        .upload-area:hover {
            border-color: #3b82f6;
            background: #f8fafc;
        }

        .upload-placeholder i {
            font-size: 40px;
            color: #3b82f6;
            margin-bottom: 10px;
        }

        .upload-placeholder p {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .upload-placeholder span {
            font-size: 12px;
            color: #6b7280;
        }

        .preview-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            display: none;
        }

        .upload-actions {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .upload-actions button {
            padding: 6px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-change {
            background: #3b82f6;
            color: white;
        }

        .btn-remove {
            background: #ef4444;
            color: white;
        }
    </style>

    <div class="content-body">
        <div class="container-fluid">

            <div class="row page-titles">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="{{ route('dashboard') }}">Dashboard | </a></li>
                    <li class="breadcrumb-item active"><a href="{{ route('page-information.edit' , $row->page_name) }}">Page Information > </a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Edit</a></li>
                </ol>
            </div>


            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="">
                                        @if (session('success'))
                                            <div class="alert alert-success">
                                                {{ session('success') }}
                                            </div>
                                        @endif

                                        <div class="compose-content">
                                            <form action="{{ route('page-information.update', $row->page_name) }}" method="POST"
                                                enctype="multipart/form-data">
                                                @csrf
                                                @method('PUT')

                                                <div class="mb-3">
                                                    <label for="small_title">Page Small Title</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Small Title:" name="small_title" value="{{ $row->small_title }}">
                                                </div>


                                                <div class="mb-3">
                                                    <label for="title">Page Title</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Title:" name="title" value="{{ $row->title }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="text">Page Text</label>
                                                    <textarea class="form-control bg-transparent" name="text" rows="3" placeholder="Text:">{{ $row->text }}</textarea>
                                                </div>

                                                <div class="mb-3">
                                                    <label for="meta_title">Meta Title</label>
                                                    <input type="text" class="form-control bg-transparent"
                                                        placeholder="Meta Title:" name="meta_title" value="{{ $row->meta_title }}">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="meta_description">Meta Description</label>
                                                    <textarea class="form-control bg-transparent" name="meta_description" rows="3" placeholder="Meta Description:">{{ $row->meta_description }}</textarea>
                                                </div>

                                                <div class="mb-3">
                                                    <label for="page_schema">Page Schema</label>
                                                    <textarea class="form-control bg-transparent" name="page_schema" rows="3" placeholder="Page Schema:">{{ $row->page_schema }}</textarea>
                                                </div>

                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i>Current Page Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">

                                                        <div class="upload-area" style="cursor: default;">

                                                            @if ($row->main_image)
                                                                <img id="" width="200" class=""
                                                                    src="{{ $row->main_image }}" />
                                                            @else
                                                                <img id="" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                            @endif
                                                        </div>



                                                    </div>

                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="main_image" id="imageInput"
                                                            accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('imageInput').click()">
                                                            <div class="upload-placeholder" id="placeholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload image</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            @if ($row->main_image)
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('/' . $row->main_image) }}" />
                                                            @else
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="{{ asset('backend/images/Anonymous 2.png') }}" />
                                                            @endif
                                                        </div>

                                                        <div class="upload-actions" id="actions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeImage()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeImage()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>


                                                <div class="text-start mt-4 mb-3">
                                                    <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span
                                                            class="me-2"><i
                                                                class="fa fa-paper-plane"></i></span>Submit</button>

                                                    <a href="{{ route('page-information.edit', $row->page_name) }}"
                                                        class="btn btn-danger light btn-sl-sm">
                                                        <span class="me-2"><i class="fa fa-times"></i></span>Discard
                                                    </a>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        const input = document.getElementById('imageInput');
        const preview = document.getElementById('previewImage');
        const placeholder = document.getElementById('placeholder');
        const actions = document.getElementById('actions');

        input.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    placeholder.style.display = 'none';
                    actions.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImage() {
            input.click();
        }

        function removeImage() {
            input.value = '';
            preview.src = '';
            preview.style.display = 'none';
            placeholder.style.display = 'block';
            actions.style.display = 'none';
        }
    </script>

    <script>
        const inputEN = document.getElementById('imageInputEN');
        const previewEN = document.getElementById('previewImageEN');
        const placeholderEN = document.getElementById('placeholderEN');
        const actionsEN = document.getElementById('actionsEN');

        inputEN.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    previewEN.src = e.target.result;
                    previewEN.style.display = 'block';
                    placeholderEN.style.display = 'none';
                    actionsEN.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImageEN() {
            inputEN.click();
        }

        function removeImageEN() {
            inputEN.value = '';
            previewEN.src = '';
            previewEN.style.display = 'none';
            placeholderEN.style.display = 'block';
            actionsEN.style.display = 'none';
        }
    </script>
@endsection
