@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<link
      rel="stylesheet"
      href="{{asset('assets/css/swiper-custome-bundle.css')}}"
      media="print"
      onload="this.media = 'all'"
    />
    <noscript>
      <link rel="stylesheet" href="{{asset('assets/css/swiper-custome-bundle.css')}}" />
    </noscript>
    <link rel="stylesheet" href="{{asset('assets/css/pages/about.css')}}" />    
@endpush
@push('scripts')
<script src="{{asset('assets/js/swiper-bundle.min.js')}}" defer></script>
<script
      src="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/js/intlTelInput.min.js"
      defer
    ></script>
    <script src="{{asset('assets/js/home.js')}}" defer></script>

@endpush
    <section class="our-company-history">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-6">
            <div class="company-history-image">
              <div class="company-history-img">
                <figure>
                  <img
                    src="{{asset('assets/images/company-history-img.jpg')}}"
                    alt="years of experience"
                    loading="lazy"
                    decoding="async"
                  />
                </figure>
              </div>
              <div class="company-experience">
                <div class="company-experience-content">
                  <h3><span class="counter">25</span>+</h3>
                  <p>years of experience</p>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div class="company-history-content">
              <div class="section-title">
                <h3>our history</h3>
                <h2>Crafting structures that last a lifetime</h2>
              </div>
              <div
                class="company-history-body min-text"
                style="max-height: 300px"
              >
                <p>
                  We specialize in a wide range of construction services,
                  including residential, commercial, and industrial projects.
                  From initial design to final inspection, we work closely with
                  our clients to understand their unique needs and vision.
                </p>
                <p>
                  It is a long established fact that a reader will be distracted
                  by the readable content of a page when looking at its layout.
                  The point of using Lorem Ipsum is that it has a more-or-less
                  normal distribution of letters.
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="about-us">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-7">
            <div class="about-content">
              <div class="section-title">
                <h3>about us</h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque">
                  Crafting structures that last a lifetime
                </h2>
                <div
                  class="about-content-body min-text"
                  style="max-height: 300px"
                >
                  Crafting structures that last a lifetime requires a holistic
                  approach that integrates advanced materials, resilient design,
                  regular maintenance, and sustainability practices. By learning
                  from historical examples and leveraging modern technology.
                  <ul>
                    <li>Comprehensive Services</li>
                    <li>Advanced Technology</li>
                    <li>Transparent Communication</li>
                  </ul>
                </div>
              </div>
              <div class="about-content-footer">
                <div class="about-footer-btn">
                  <a href="#" class="btn-default">know more</a>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-5">
            <div class="about-image">
              <div class="about-img">
                <figure>
                  <img
                    src="{{asset('assets/images/about-us-img.webp')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                  />
                </figure>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="what-we-do">
      <div class="container">
        <div class="row">
          @for ($i = 0; $i < 4; $i++)
          <div class="col-lg-3 col-6">
            <div class="company-counter-item">
              <div class="company-counter-content">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-phone.svg')}}"
                    alt=""
                    width="50"
                    height="50"
                    loading="lazy"
                    decoding="async"
                  />
                </div>
                <h3><span class="counter">99</span>+</h3>
                <p class="line-clamp-1">buildings control approval rate</p>
              </div>
            </div>
          </div>
          @endfor
        </div>
      </div>
    </section>
    <section class="our-mission-vision cta-box position-relative">
      <img src="{{ asset('assets/images/cta-box-bg.png') }}" alt="" role="presentation" class="bg-image" loading="lazy" decoding="async" style="object-fit: contain;">
      <div class="container">
        <div class="row">
          <div class="col-lg-6">
            <div class="mission-vision-item wow fadeInUp">
              <div class="icon-box">
                <img
                  src="{{asset('assets/images/icon-our-mission.svg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                  width="70"
                  height="70"
                />
              </div>
              <div class="mission-vision-content">
                <h3>our mission</h3>
                <div class="min-text" style="height: 100px">
                  Simple actions make a difference. It starts and ends with each
                  employee striving to work safer every single day so they can
                  return.
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <div
              class="mission-vision-item wow fadeInUp"
              data-wow-delay="0.25s"
            >
              <div class="icon-box">
                <img
                  src="{{asset('assets/images/icon-our-vision.svg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                  width="70"
                  height="70"
                />
              </div>
              <div class="mission-vision-content">
                <h3>our vision</h3>
                <div class="min-text" style="height: 100px">
                  Simple actions make a difference. It starts and ends with each
                  employee striving to work safer every single day so they can
                  return.
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="why-choose-us">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <div class="section-title">
              <h3>why choose us?</h3>
              <h2>Why we're your best choice</h2>
              <p>
                Developed in close collaboration with our partners and clients,
                combines industry knowledge, decades of experience, ingenuity
                and adaptability to deliver excellence to our clients.
              </p>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-4 col-md-6">
            <div class="why-choose-item">
              <div class="icon-box">
                <img
                  src="{{asset('assets/images/icon-why-choose-1.svg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                  width="70"
                  height="70"
                />
              </div>
              <div class="why-choose-content">
                <h3>innovation solutions</h3>
                <p class="line-clamp-3">
                  Simple actions make a difference. It starts and ends with each
                  employee striving to work safer every single day so they can
                  return.
                </p>
              </div>
            </div>
          </div>

          <div class="col-lg-4 col-md-6">
            <div class="why-choose-image">
              <figure class="image-anime reveal">
                <img
                  src="{{asset('assets/images/why-choose-img-1.jpg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                   width="410"
                  height="310"
                />
              </figure>
            </div>
          </div>
          <div class="col-lg-4 col-md-6">
            <div class="why-choose-item">
              <div class="icon-box">
                <img src="{{asset('assets/images/icon-why-choose-2.svg')}}" alt=""
                 width="70"
                  height="70" />
              </div>
              <div class="why-choose-content">
                <h3>quality craftsmanship</h3>
                <p class="line-clamp-3">
                  Simple actions make a difference. It starts and ends with each
                  employee striving to work safer every single day so they can
                  return.
                </p>
              </div>
            </div>
          </div>

          <div class="col-lg-4 col-md-6">
            <div class="why-choose-image">
              <figure class="image-anime">
                <img
                  src="{{asset('assets/images/why-choose-img-2.jpg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                  width="410"
                  height="310"
                />
              </figure>
            </div>
          </div>

          <div class="col-lg-4 col-md-6">
            <div class="why-choose-item">
              <div class="icon-box">
                <img
                  src="{{asset('assets/images/icon-why-choose-3.svg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                   width="70"
                  height="70"
                />
              </div>
              <div class="why-choose-content">
                <h3>expertise and experience</h3>
                <p class="line-clamp-3">
                  Simple actions make a difference. It starts and ends with each
                  employee striving to work safer every single day so they can
                  return.
                </p>
              </div>
            </div>
          </div>

          <div class="col-lg-4 col-md-6">
            <div class="why-choose-image">
              <figure class="image-anime">
                <img
                  src="{{asset('assets/images/why-choose-img-3.jpg')}}"
                  alt=""
                  loading="lazy"
                  decoding="async"
                  width="410"
                  height="310"
                />
              </figure>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="our-testimonial">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <div class="section-title">
              <h3>testimonials</h3>
              <h2>What people are saying about us</h2>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-lg-12">
            <div class="testimonial-slider">
              <div class="swiper">
                <div class="swiper-wrapper">
                  @for ($i = 0; $i < 6; $i++)
                  <div class="swiper-slide">
                    <div>
                      <div class="author-image">
                        <figure class="text-center">
                          <img
                            src="{{asset('assets/images/author-1.jpg')}}"
                            alt=""
                            width="100"
                            height="100"
                            loading="lazy"
                            decoding="async"
                          />
                        </figure>
                      </div>
                    </div>
                  </div>
                  @endfor
                </div>
                <div class="swiper-pagination"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
@endsection