@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/css/intlTelInput.min.css"
      media="print"
      onload="this.media = 'all'"
    />
    <style>
      .pagination-wrapper {
        margin: 60px 0 40px;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 20px;
      }

      .pagination {
        display: flex;
        gap: 8px;
        list-style: none;
        padding: 0;
        margin: 0;
      }

      .page-item {
        display: flex;
      }

      .page-link {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 44px;
        height: 44px;
        padding: 0 16px;
        background: white;
        color: #4a5568;
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        font-weight: 600;
        font-size: 14px;
        text-decoration: none;
        transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
      }

      .page-link:hover {
        background: #f7fafc;
        border-color: #cbd5e0;
        transform: translateY(-2px);
      }

      .page-item.active .page-link {
        background: var(--accent-color);
        color: white;
        border-color: transparent;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
      }

      .nav-arrow .page-link {
        font-size: 12px;
        font-weight: 700;
      }
    </style>
    <link rel="stylesheet" href="{{asset('assets/css/text-editor.css')}}" media="print" onload="this.media = 'all'">
    <noscript>
        <link rel="stylesheet" href="{{asset('assets/css/text-editor.css')}}">
    </noscript>
    <link rel="stylesheet" href="{{asset('assets/css/pages/blog-details.css')}}" />    
@endpush
@push('scripts')
<script
      src="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/js/intlTelInput.min.js"
      defer
    ></script>
    <script>
      const phoneNumber = "+91233213";
      const whatsappNumber = "+91233213";
    </script>
    <script>
        const whiteIcon = "{{asset('assets/images/icon-white-phone.svg')}}";
    </script>
    <script src="{{asset('assets/js/blog-details.js')}}" defer></script>
@endpush
    <section class="page-service-single">
      <div class="container">
        <div class="row">
          <div class="col-lg-8">
            <div class="service-single-content">
              <div class="service-images-slider">
                      <div class="service-image-item">
                        <figure class="image-anime">
                          <img
                            src="{{asset('assets/images/service-img-1.jpg')}}"
                            alt=""
                            loading="lazy"
                            decoding="async"
                          />
                        </figure>
                      </div>
              </div>
              <div class="service-categories-list tableOfContents mobile">
                <h3>Content</h3>
                <ul></ul>
              </div>
              <div class="service-entry"></div>
              <div class="service-sustainable">
                <div class="row">
                  <div>
                    <div id="articleContainer" class="article-content mt-14">
                      <p>
                        Would you like to study medicine in Germany in English
                        and join one of the strongest medical education systems
                        in Europe? Germany offers advanced medical programs
                        taught in English to meet the needs of international
                        students, especially those who wish to pursue medical
                        studies without prior German language proficiency. These
                        programs provide comprehensive education that combines
                        theoretical study with practical training in advanced
                        hospitals, focusing on clinical skills, medical
                        research, and modern medical practices. Studying in
                        English also allows students to gradually integrate into
                        German culture and communicate within a diverse
                        international medical community.
                      </p>

                      <h2>
                        Advantages of Studying Medicine in Germany in English
                        for International Students
                      </h2>

                      <p>
                        Studying medicine in Germany in English is an excellent
                        option for international students seeking high-quality
                        European education in an advanced academic environment.
                        German universities are distinguished by the following:
                      </p>

                      <ul>
                        <li>
                          World-class medical education, as German medical
                          schools rank among the best globally, offering modern
                          curricula that integrate scientific research with
                          clinical training.
                        </li>
                        <li>
                          German medical degrees are widely recognized, opening
                          career opportunities in Germany, the European Union,
                          and many Arab countries.
                        </li>
                        <li>
                          Early practical training opportunities in university
                          hospitals, such as Freiburg University Hospital,
                          providing students with real clinical experience.
                        </li>
                        <li>
                          Strong career prospects due to Germany’s shortage of
                          medical professionals, along with facilitated access
                          to medical specialization programs after graduation.
                        </li>
                        <li>
                          An international learning environment that promotes
                          multicultural interaction and academic exchange.
                        </li>
                        <li>
                          Professional and financial stability thanks to the
                          high quality of education and training.
                        </li>
                        <li>
                          Study opportunities at prestigious universities with
                          strong academic reputations, such as Jacobs University
                          Bremen and Leipzig University.
                        </li>
                      </ul>

                      <h2>
                        Universities That Teach Medicine in English in Germany
                      </h2>

                      <p>
                        A limited number of universities and institutions in
                        Germany offer medical programs or pathways taught in
                        English. The most notable include:
                      </p>

                      <ul>
                        <li>Jacobs University Bremen</li>
                        <li>Charité – Universitätsmedizin Berlin</li>
                        <li>Heidelberg University</li>
                        <li>Tübingen University</li>
                        <li>Leipzig University</li>
                        <li>Ulm University</li>
                      </ul>

                      <p>
                        Read also:
                        <a
                          href="https://egecmena.com/ar/%D8%A7%D8%AF%D8%B1%D8%B3-%D9%81%D9%8A-%D8%A7%D9%84%D9%85%D8%A7%D9%86%D9%8A%D8%A7/%D8%AF%D8%B1%D8%A7%D8%B3%D8%A9-%D8%A7%D9%84%D8%B7%D8%A8-%D9%81%D9%8A-%D8%A3%D9%84%D9%85%D8%A7%D9%86%D9%8A%D8%A7-%D9%84%D9%84%D9%85%D8%B5%D8%B1%D9%8A%D9%8A%D9%86"
                        >
                          Studying Medicine in Germany for Egyptians
                        </a>
                      </p>

                      <h2>
                        Requirements for Studying Medicine in Germany in English
                      </h2>

                      <p>
                        Admission requirements vary by university, but most
                        institutions share common criteria:
                      </p>

                      <ul>
                        <li>A recognized high school certificate.</li>
                        <li>
                          Passing the TestAS exam at some universities to assess
                          academic aptitude.
                        </li>
                        <li>
                          Proof of language proficiency: DSH for German-taught
                          programs, or IELTS / TOEFL for English-taught
                          programs.
                        </li>
                        <li>
                          Additional documents such as a CV, motivation letter,
                          and proof of financial ability.
                        </li>
                      </ul>

                      <p>
                        Start your academic journey with EGEC, where expert
                        advisors provide detailed guidance on admission
                        requirements and official procedures.
                      </p>

                      <h2>
                        The Difference Between Studying Medicine in English and
                        German
                      </h2>

                      <div>
                        <table cellspacing="0">
                          <tbody>
                            <tr>
                              <td style="text-align: center">
                                Comparison Aspect
                              </td>
                              <td style="text-align: center">
                                English-Taught Programs
                              </td>
                              <td style="text-align: center">
                                German-Taught Programs
                              </td>
                            </tr>
                            <tr>
                              <td style="text-align: center">
                                Language of Study & Exams
                              </td>
                              <td style="text-align: center">
                                Available in limited programs; clinical training
                                requires German for patient interaction.
                              </td>
                              <td style="text-align: center">
                                Official language for all public universities;
                                all state exams are conducted in German.
                              </td>
                            </tr>
                            <tr>
                              <td style="text-align: center">
                                Language Requirements
                              </td>
                              <td style="text-align: center">
                                IELTS or TOEFL required, but German proficiency
                                is necessary later.
                              </td>
                              <td style="text-align: center">
                                C1 level such as DSH or TestDaF.
                              </td>
                            </tr>
                            <tr>
                              <td style="text-align: center">
                                Career & Training Opportunities
                              </td>
                              <td style="text-align: center">
                                Requires learning German medical terminology to
                                work in German hospitals.
                              </td>
                              <td style="text-align: center">
                                Fully prepares students for the German
                                healthcare system.
                              </td>
                            </tr>
                          </tbody>
                        </table>
                      </div>

                      <h2>Duration and Study System of Medicine in Germany</h2>

                      <p>
                        Although studying medicine in English is still limited,
                        the program duration is the same as German-taught
                        programs. Medical studies in Germany last approximately
                        6 years and 3 months and are divided into three stages:
                        pre-clinical studies (2 years), clinical studies (3
                        years), and a final practical year with intensive
                        hospital training.
                      </p>

                      <h2>Costs of Studying Medicine in Germany in English</h2>

                      <p>
                        Tuition fees vary depending on the university and
                        program. English-taught medical programs are usually
                        offered by private universities, with fees ranging from
                        100 to 500 euros per semester. For detailed cost
                        information and payment methods, students can contact
                        EGEC advisors directly.
                      </p>

                      <h2>
                        Career Opportunities After Studying Medicine in Germany
                        in English
                      </h2>

                      <ul>
                        <li>Medical and academic research positions.</li>
                        <li>Telemedicine and digital healthcare platforms.</li>
                        <li>
                          Private healthcare sector, pharmaceutical companies,
                          and medical technology firms.
                        </li>
                        <li>
                          Medical residency programs (Facharzt) after meeting
                          language and licensing requirements.
                        </li>
                        <li>
                          Maritime and aviation medicine, offering global travel
                          opportunities.
                        </li>
                      </ul>

                      <h2>
                        Available Alternatives if English Medical Programs Are
                        Not Available
                      </h2>

                      <ul>
                        <li>
                          Studying medicine in German, which requires language
                          proficiency.
                        </li>
                        <li>
                          Foundation or preparatory programs taught in English,
                          followed by German medical studies.
                        </li>
                        <li>
                          Alternative healthcare programs taught in English,
                          such as nursing, pharmacy, or applied medical
                          sciences.
                        </li>
                      </ul>

                      <h2>
                        Steps to Apply for Studying Medicine in Germany in
                        English Through EGEC
                      </h2>

                      <ul>
                        <li>
                          Preparing the application file:
                          <ul>
                            <li>Valid passport.</li>
                            <li>Educational certificates.</li>
                            <li>Official transcripts.</li>
                            <li>Identity documents.</li>
                            <li>Recent personal photo.</li>
                            <li>
                              Choosing the main specialization and alternatives.
                            </li>
                          </ul>
                        </li>
                        <li>
                          Post-acceptance procedures:
                          <ul>
                            <li>Document legalization.</li>
                            <li>Submitting original documents.</li>
                            <li>Authorizing EGEC to complete registration.</li>
                            <li>
                              Sending documents via approved courier services.
                            </li>
                          </ul>
                        </li>
                      </ul>

                      <p>
                        In conclusion, studying medicine in Germany in English
                        is a unique opportunity for international students to
                        receive advanced medical education in a global academic
                        environment, with strong emphasis on practical training
                        and research. Partnering with EGEC ensures a smooth
                        application process and professional guidance throughout
                        your academic journey.
                      </p>

                      <h2>
                        Frequently Asked Questions About Studying Medicine in
                        Germany in English
                      </h2>

                      <h3>
                        Are there medical schools in Germany that teach in
                        English?
                      </h3>
                      <p>
                        Yes, some institutions such as medical universities
                        designed for international students offer full medical
                        programs in English, following international standards.
                      </p>

                      <h3>Can I study in Germany if I only speak English?</h3>
                      <p>
                        Yes, as long as you meet the language requirements of
                        the chosen program. However, learning German expands
                        academic and professional opportunities.
                      </p>

                      <h3>Can foreign doctors work in Germany?</h3>
                      <p>
                        Yes, foreign-qualified doctors must obtain official
                        recognition and professional licensing to practice
                        medicine legally in Germany, after meeting equivalency
                        and language requirements.
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="service-sidebar">
              <div class="service-categories-list tableOfContents">
                <h3>Content</h3>
                <ul></ul>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="page-team">
      <div class="container">
        <div class="row section-row">
          <div class="col-lg-12">
            <div class="section-title">
              <h3>products</h3>
              <h2 class="text-anime-style-3">Related Blogs</h2>
            </div>
          </div>
        </div>
        <div class="row">
          @for ($i = 0; $i < 3; $i++)
          <div class="col-lg-4 col-md-6">
            <article class="blog-item position-relative">
                <a href="{{route('blogDetails')}}" class="card-link"></a>
              <div class="post-featured-image">
                <figure class="image-anime">
                    <img
                      src="{{asset('assets/images/post-1.jpg')}}"
                      alt=""
                      loading="lazy"
                      decoding="async"
                    />
                </figure>
              </div>
              <div class="post-item-content">
                <div class="post-item-body">
                  <h2>
                    10 Essential Tips for Choosing the Right Builder
                  </h2>
                </div>
                <div class="post-item-footer">
                  <a href="#" class="readmore-btn">read more</a>
                </div>
              </div>
            </article>
          </div>
         @endfor  
        </div>
        <div class="pagination-wrapper">
          <ul class="pagination">
            <li class="page-item nav-arrow">
              <a class="page-link" href="#" aria-label="Previous">
                <i class="fa-solid fa-chevron-left"></i>
                <span>Prev</span>
              </a>
            </li>
            <li class="page-item"><a class="page-link" href="#">1</a></li>
            <li class="page-item active">
              <span class="page-link">2</span>
            </li>
            <li class="page-item"><a class="page-link" href="#">3</a></li>
            <li class="page-item nav-arrow">
              <a class="page-link" href="#" aria-label="Next">
                <span>Next</span>
                <i class="fa-solid fa-chevron-right"></i>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </section>
    <section class="contact-us">
      <img
        src="{{asset('assets/images/contact-us-bg.png')}}"
        alt=""
        class="bg-image"
        loading="lazy"
        decoding="async"
      />
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-4 col-md-5">
            <div class="contact-sidebar">
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-phone.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                  />
                </div>
                <div class="contact-info-content">
                  <p>call support center 24/7</p>
                  <h3>
                    <a href="tel:+18091206705">
                      +1 809 120 6705
                    </a>
                  </h3>
                </div>
              </div>
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-mail.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                  />
                </div>
                <div class="contact-info-content">
                  <p>write to us</p>
                  <h3>
                    <a href="mailto:info@domain.com">
                      info@domain.com
                    </a>
                  </h3>
                </div>
              </div>
              <div>
                <div class="embed-map-responsive">
                  <div class="embed-map-container">
                    <iframe
                      class="embed-map-frame"
                      frameborder="0"
                      scrolling="no"
                      marginheight="0"
                      marginwidth="0"
                      loading="lazy"
                      decoding="async"
                      src="https://maps.google.com/maps?width=600&height=400&hl=en&q=Cairo&t=k&z=13&ie=UTF8&iwloc=B&output=embed"
                    ></iframe
                    ><a
                      href="https://funclicker.org"
                      style="
                        font-size: 2px !important;
                        color: gray !important;
                        position: absolute;
                        bottom: 0;
                        left: 0;
                        z-index: 1;
                        max-height: 1px;
                        overflow: hidden;
                      "
                      >Fun Clicker</a
                    >
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-8 col-md-7">
            <div class="contact-form">
              <div class="section-title">
                <h3>contact us</h3>
                <h2 class="text-anime-style-3">Get in touch with us</h2>
              </div>
              <form id="contactForm" action="#" method="POST" novalidate>
                <div class="row">
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="name"
                      class="form-control preventNumbers"
                      id="nameInput"
                      placeholder="Enter Your name"
                      required=""
                    />
                    <div id="nameError" class="error-msg">
                      <small class="hidden"
                        >Name must be at least 3 characters.</small
                      >
                      <small class="hidden">Name cannot contain numbers.</small>
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="email"
                      name="email"
                      class="form-control"
                      id="emailInput"
                      placeholder="Enter Your email"
                      required=""
                    />
                    <div id="emailError" class="error-msg hidden">
                      Please enter a valid email address.
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="phone"
                      class="form-control"
                      id="phoneInput"
                      placeholder="Phone number"
                      required=""
                    />
                    <div id="validMsg" class="error-msg hidden"></div>
                    <input
                      type="hidden"
                      readonly
                      id="actualPhone"
                      name="actualPhone"
                    />
                  </div>
                  <div class="form-group col-md-12 mb-5">
                    <textarea
                      name="msg"
                      class="form-control"
                      id="message"
                      rows="3"
                      placeholder="Message"
                      required=""
                    ></textarea>
                    <div id="messageError" class="error-msg hidden">
                      Message must be at least 10 characters.
                    </div>
                  </div>
                  <div class="col-md-12">
                    <button type="submit" class="btn-default">submit</button>
                    <div id="msgSubmit" class="h3 hidden"></div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
@endsection