@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<style>
      .pagination-wrapper {
        margin: 60px 0 40px;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 20px;
      }

      .pagination {
        display: flex;
        gap: 8px;
        list-style: none;
        padding: 0;
        margin: 0;
      }

      .page-item {
        display: flex;
      }

      .page-link {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 44px;
        height: 44px;
        padding: 0 16px;
        background: white;
        color: #4a5568;
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        font-weight: 600;
        font-size: 14px;
        text-decoration: none;
        transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
      }

      .page-link:hover {
        background: #f7fafc;
        border-color: #cbd5e0;
        transform: translateY(-2px);
      }

      .page-item.active .page-link {
        background: var(--accent-color);
        color: white;
        border-color: transparent;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
      }

      .nav-arrow .page-link {
        font-size: 12px;
        font-weight: 700;
      }
      /* Added internal styles */
.post-date {
    margin-bottom: 10px;
    color: #64748b;
    font-size: 0.9rem;
    font-weight: 500;
}
.post-date i {
    color: var(--accent-color, #3b82f6);
}
    </style>
@endpush

    <section class="our-blog">
      <div class="container">
        <div class="row">
          @for ($i = 0; $i < 6; $i++)
          <div class="col-lg-4 col-md-6">
            <article class="blog-item position-relative">
                <a href="{{route('blogDetails')}}" class="card-link"></a>
              <div class="post-featured-image">
                <figure class="image-anime">
                    <img
                      src="{{asset('assets/images/post-1.jpg')}}"
                      alt=""
                      loading="lazy"
                      decoding="async"
                    />
                </figure>
              </div>
              <div class="post-item-content">
                <div class="post-date">
    <i class="fa-regular fa-calendar-days"></i>
    <span>{{ date('M d, Y') }}</span>
</div>
                <div class="post-item-body">
                  <h2>
                    10 Essential Tips for Choosing the Right Builder
                  </h2>
                </div>
                <div class="post-item-footer">
                  <a href="#" class="readmore-btn">read more</a>
                </div>
              </div>
            </article>
          </div>
         @endfor        
          
        </div>
        <div class="pagination-wrapper">
          <ul class="pagination">
            <li class="page-item nav-arrow">
              <a class="page-link" href="#" aria-label="Previous">
                <i class="fa-solid fa-chevron-left"></i>
                <span>Prev</span>
              </a>
            </li>
            <li class="page-item"><a class="page-link" href="#">1</a></li>
            <li class="page-item active">
              <span class="page-link">2</span>
            </li>
            <li class="page-item"><a class="page-link" href="#">3</a></li>
            <li class="page-item nav-arrow">
              <a class="page-link" href="#" aria-label="Next">
                <span>Next</span>
                <i class="fa-solid fa-chevron-right"></i>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </section>
@endsection