@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<style>
      .pagination-wrapper {
        margin: 60px 0 40px;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 20px;
      }

      .pagination {
        display: flex;
        gap: 8px;
        list-style: none;
        padding: 0;
        margin: 0;
      }

      .page-item {
        display: flex;
      }

      .page-link {
        display: flex;
        align-items: center;
        justify-content: center;
        min-width: 44px;
        height: 44px;
        padding: 0 16px;
        background: white;
        color: #4a5568;
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        font-weight: 600;
        font-size: 14px;
        text-decoration: none;
        transition: all 0.25s cubic-bezier(0.4, 0, 0.2, 1);
        cursor: pointer;
      }

      .page-link:hover {
        background: #f7fafc;
        border-color: #cbd5e0;
        transform: translateY(-2px);
      }

      .page-item.active .page-link {
        background: var(--accent-color);
        color: white;
        border-color: transparent;
        box-shadow: 0 4px 12px rgba(59, 130, 246, 0.25);
      }

      .nav-arrow .page-link {
        font-size: 12px;
        font-weight: 700;
      }
    </style>
@endpush
@push('scripts')
<script src="{{asset('assets/js/home.js')}}" defer></script>
@endpush
    <section class="our-service">
      <div class="light-bg-section">
        <div class="container-fluid">
          <div class="row section-row">
            <div class="col-lg-12">
              <div class="section-title">
                <h3>our Categories</h3>
                <h2 class="line-clamp-2">Our construction Categories</h2>
              </div>
            </div>
          </div>
          <div class="row">
            @for ($i = 0; $i < 6; $i++)
            <div class="col-lg-4 col-md-6">
              <div class="service-item">
                <a href="products.html">
                  <div class="service-image">
                    <figure>
                      <img
                        src="{{asset('assets/images/service-img-1.jpg')}}"
                        alt=""
                        loading="lazy"
                        decoding="async"
                      />
                    </figure>
                  </div>
                  <div class="service-body">
                    <div class="service-body-title">
                      <h3 class="line-clamp-1">building construction</h3>
                      <div class="post-item-footer">
                        <a href="#" class="readmore-btn">read more</a>
                      </div>
                    </div>
                  </div>
                </a>
              </div>
            </div>
            @endfor
            
            <div class="pagination-wrapper">
              <ul class="pagination">
                <li class="page-item nav-arrow">
                  <a class="page-link" href="#" aria-label="Previous">
                    <i class="fa-solid fa-chevron-left"></i>
                    <span>Prev</span>
                  </a>
                </li>
                <li class="page-item"><a class="page-link" href="#">1</a></li>
                <li class="page-item active">
                  <span class="page-link">2</span>
                </li>
                <li class="page-item"><a class="page-link" href="#">3</a></li>
                <li class="page-item nav-arrow">
                  <a class="page-link" href="#" aria-label="Next">
                    <span>Next</span>
                    <i class="fa-solid fa-chevron-right"></i>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="contact-us">
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-4 col-md-5">
            <div class="contact-sidebar">
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-phone.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                  />
                </div>
                <div class="contact-info-content">
                  <p>call support center 24/7</p>
                  <h3>
                    <a href="tel:+18091206705">
                      +1 809 120 6705
                    </a>
                  </h3>
                </div>
              </div>
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-mail.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                  />
                </div>
                <div class="contact-info-content">
                  <p>write to us</p>
                  <h3>
                    <a href="mailto:info@domain.com">
                      info@domain.com
                    </a>
                  </h3>
                </div>
              </div>
              <div>
                <div class="embed-map-responsive">
                  <div class="embed-map-container">
                    <iframe
                      class="embed-map-frame"
                      frameborder="0"
                      scrolling="no"
                      marginheight="0"
                      marginwidth="0"
                      loading="lazy"
                      decoding="async"
                      src="https://maps.google.com/maps?width=600&height=400&hl=en&q=Cairo&t=k&z=13&ie=UTF8&iwloc=B&output=embed"
                    ></iframe
                    ><a
                      href="https://funclicker.org"
                      style="
                        font-size: 2px !important;
                        color: gray !important;
                        position: absolute;
                        bottom: 0;
                        left: 0;
                        z-index: 1;
                        max-height: 1px;
                        overflow: hidden;
                      "
                      >Fun Clicker</a
                    >
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-8 col-md-7">
            <div class="contact-form">
              <div class="section-title">
                <h3>contact us</h3>
                <h2>Get in touch with us</h2>
              </div>
              <form id="contactForm" action="#" method="POST" novalidate>
                <div class="row">
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="name"
                      class="form-control preventNumbers"
                      id="nameInput"
                      placeholder="Enter Your name"
                      required=""
                    />
                    <div id="nameError" class="error-msg">
                      <small class="hidden"
                        >Name must be at least 3 characters.</small
                      >
                      <small class="hidden">Name cannot contain numbers.</small>
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="email"
                      name="email"
                      class="form-control"
                      id="emailInput"
                      placeholder="Enter Your email"
                      required=""
                    />
                    <div id="emailError" class="error-msg hidden">
                      Please enter a valid email address.
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="phone"
                      class="form-control"
                      id="phoneInput"
                      placeholder="Phone number"
                      required=""
                    />
                    <div id="validMsg" class="error-msg hidden"></div>
                    <input
                      type="hidden"
                      readonly
                      id="actualPhone"
                      name="actualPhone"
                    />
                  </div>
                  <div class="form-group col-md-12 mb-5">
                    <textarea
                      name="msg"
                      class="form-control"
                      id="message"
                      rows="3"
                      placeholder="Message"
                      required=""
                    ></textarea>
                    <div id="messageError" class="error-msg hidden">
                      Message must be at least 10 characters.
                    </div>
                  </div>
                  <div class="col-md-12">
                    <button type="submit" class="btn-default">submit</button>
                    <div id="msgSubmit" class="h3 hidden"></div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </section>
@endsection