@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/css/intlTelInput.min.css"
      media="print"
      onload="this.media = 'all'"
    />
<link rel="stylesheet" href="{{asset('assets/css/pages/contact-us.css')}}" />
@endpush
@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/js/intlTelInput.min.js"></script>
@endpush
    <section class="contact-information">
      <div class="container">
        <div class="row">
          <div class="col-md-4">
            <div class="contact-info-item">
              <div class="icon-box">
                <img src="{{asset('assets/images/icon-phone.svg')}}" alt="" width="50" height="50" />
              </div>
              <div class="contact-info-body">
                <h3>call support center 24/7</h3>
                <p>+1 809 120 6705</p>
              </div>
            </div>
          </div>

          <div class="col-md-4">
            <div class="contact-info-item">
              <div class="icon-box">
                <img src="{{asset('assets/images/icon-mail.svg')}}" alt="" width="50" height="50" />
              </div>
              <div class="contact-info-body">
                <h3>write to us</h3>
                <p>Support@domain.com</p>
              </div>
            </div>
          </div>

          <div class="col-md-4">
            <div class="contact-info-item">
              <div class="icon-box">
                <img src="{{asset('assets/images/icon-location.svg')}}" alt="" width="50" height="50" />
              </div>
              <div class="contact-info-body">
                <h3>visit us</h3>
                <p>2972 Westheimer Rd. Santa Ana, Illinois 85486</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
    <section class="contact-us page-contact-us">
      <img
        src="{{asset('assets/images/contact-us-bg.png')}}"
        alt=""
        loading="lazy"
        decoding="async"
        class="bg-image"
      />
      <div class="container">
        <div class="row align-items-center">
          <div class="col-lg-4 col-md-5">
            <div class="contact-sidebar">
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-phone.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                    width="40"
                    height="40"
                  />
                </div>
                <div class="contact-info-content">
                  <p>call support center 24/7</p>
                  <h3>
                    <a href="tel:+18091206705">
                      +1 809 120 6705
                    </a>
                  </h3>
                </div>
              </div>
              <div class="contact-info">
                <div class="icon-box">
                  <img
                    src="{{asset('assets/images/icon-mail.svg')}}"
                    alt=""
                    loading="lazy"
                    decoding="async"
                    width="40"
                    height="40"
                  />
                </div>
                <div class="contact-info-content">
                  <p>write to us</p>
                  <h3>
                    <a href="mailto:info@domain.com">
                      info@domain.com
                    </a>
                  </h3>
                </div>
              </div>      
            </div>
          </div>
          <div class="col-lg-8 col-md-7">
            <div class="contact-form">
              <div class="section-title">
                <h3>contact us</h3>
                <h2 class="text-anime-style-3" data-cursor="-opaque">
                  Get in touch with us
                </h2>
              </div>
              <form id="contactForm" action="#" method="POST" novalidate>
                <div class="row">
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="name"
                      class="form-control preventNumbers"
                      id="nameInput"
                      placeholder="Enter Your name"
                      required=""
                    />
                    <div id="nameError" class="error-msg">
                      <small class="hidden"
                        >Name must be at least 3 characters.</small
                      >
                      <small class="hidden">Name cannot contain numbers.</small>
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="email"
                      name="email"
                      class="form-control"
                      id="emailInput"
                      placeholder="Enter Your email"
                      required=""
                    />
                    <div id="emailError" class="error-msg hidden">
                      Please enter a valid email address.
                    </div>
                  </div>
                  <div class="form-group col-md-6 mb-4">
                    <input
                      type="text"
                      name="phone"
                      class="form-control"
                      id="phoneInput"
                      placeholder="Phone number"
                      required=""
                    />
                    <div id="validMsg" class="error-msg hidden"></div>
                    <input
                      type="hidden"
                      readonly
                      id="actualPhone"
                      name="actualPhone"
                    />
                  </div>
                  <div class="form-group col-md-12 mb-5">
                    <textarea
                      name="msg"
                      class="form-control"
                      id="message"
                      rows="3"
                      placeholder="Message"
                      required=""
                    ></textarea>
                    <div id="messageError" class="error-msg hidden">
                      Message must be at least 10 characters.
                    </div>
                  </div>
                  <div class="col-md-12">
                    <button type="submit" class="btn-default">submit</button>
                    <div id="msgSubmit" class="h3 hidden"></div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
                
    </section>
    <div class="embed-map-responsive" style="height:600px;padding:0">
                  <div class="embed-map-container" style="height:600px">
                    <iframe
                      class="embed-map-frame"
                      frameborder="0"
                      scrolling="no"
                      loading="lazy"
                      decoding="async"
                      style="height:600px !important"
                      src="https://maps.google.com/maps?width=600&height=400&hl=en&q=Cairo&t=k&z=13&ie=UTF8&iwloc=B&output=embed"
                    ></iframe
                    ><a
                      href="https://funclicker.org"
                      style="
                        font-size: 2px !important;
                        color: gray !important;
                        position: absolute;
                        bottom: 0;
                        left: 0;
                        z-index: 1;
                        max-height: 1px;
                        overflow: hidden;
                      "
                      >Fun Clicker</a
                    >
                  </div>
                </div>
@endsection