@extends("layouts.master")
@section('title', 'Home')
@section('content')
@push('styles')
<link
      rel="stylesheet"
      href="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/css/intlTelInput.min.css"
      media="print"
      onload="this.media = 'all'"
    />
<link
      rel="stylesheet"
      href="{{asset('assets/css/swiper-custome-bundle.css')}}"
      media="print"
      onload="this.media = 'all'"
    />
    <noscript>
      <link rel="stylesheet" href="{{asset('assets/css/swiper-custome-bundle.css')}}" />
    </noscript>
@endpush
@push('scripts')
<script src="{{asset('assets/js/swiper-bundle.min.js')}}" defer></script>
<script
      src="https://cdn.jsdelivr.net/npm/intl-tel-input@26.0.6/build/js/intlTelInput.min.js"
      defer
    ></script>
    <script src="{{asset('assets/js/home.js')}}" defer></script>
@endpush
  <section class="our-company-history">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-6">
              <div class="company-history-image">
                <div class="company-history-img mb-4">
                  <img
                    src="{{asset('assets/images/company-history-img.jpg')}}"
                    alt="Crafting structures that last a lifetime"
                    loading="lazy"
                    decoding="async"
                    width="555"
                    height="468"
                  />
                </div>
                <div class="company-experience">
                  <div class="company-experience-content">
                    <h3><span class="counter">25</span>+</h3>
                    <p>years of experience</p>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-6">
              <div class="company-history-content">
                <div class="section-title">
                  <h3>our history</h3>
                  <h2>Crafting structures that last a lifetime</h2>
                </div>
                <div
                  class="company-history-body min-text"
                  style="max-height: 300px"
                >
                  <p>
                    We specialize in a wide range of construction services,
                    including residential, commercial, and industrial projects.
                    From initial design to final inspection, we work closely
                    with our clients to understand their unique needs and
                    vision.
                  </p>
                  <p>
                    It is a long established fact that a reader will be
                    distracted by the readable content of a page when looking at
                    its layout. The point of using Lorem Ipsum is that it has a
                    more-or-less normal distribution of letters.
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="about-us">
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-7">
              <div class="about-content">
                <div class="section-title">
                  <h3>about us</h3>
                  <h2>Crafting structures that last a lifetime</h2>
                  <div
                    class="about-content-body min-text"
                    style="max-height: 300px"
                  >
                    Crafting structures that last a lifetime requires a holistic
                    approach that integrates advanced materials, resilient
                    design, regular maintenance, and sustainability practices.
                    By learning from historical examples and leveraging modern
                    technology.
                    <ul>
                      <li>Comprehensive Services</li>
                      <li>Advanced Technology</li>
                      <li>Transparent Communication</li>
                    </ul>
                  </div>
                </div>
                <div class="about-content-footer">
                  <div class="about-footer-btn">
                    <a href="{{ route('about') }}" class="btn-default">know more</a>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-5">
              <div>
                <img
                  src="{{asset('assets/images/about-us-img.webp')}}"
                  alt="Crafting structures that last a lifetime"
                  loading="lazy"
                  decoding="async"
                  width="464"
                  height="522"
                />
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="what-we-do">
        <div class="container">
          <div class="row">
            @for ($i = 0; $i < 4; $i++)
            <div class="col-lg-3 col-6">
              <div class="company-counter-item">
                <div class="company-counter-content">
                  <div class="icon-box">
                    <img
                      src="{{asset('assets/images/icon-phone.svg')}}"
                      alt="phone icon"
                      role="presentation"
                      width="50"
                      height="50"
                      loading="lazy"
                      decoding="async"
                    />
                  </div>
                  <h3><span class="counter">99</span>+</h3>
                  <p class="line-clamp-1">buildings control approval rate</p>
                </div>
              </div>
            </div>
            @endfor
          </div>
        </div>
      </section>
      <section class="our-testimonial">
        <div class="container">
          <div class="row section-row">
            <div class="col-lg-12">
              <div class="section-title">
                <h3>testimonials</h3>
                <h2>What people are saying about us</h2>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-lg-12">
              <div class="testimonial-slider">
                <div class="swiper">
                  <div class="swiper-wrapper">
                    @for ($i = 0; $i < 6; $i++)
                    <div class="swiper-slide">
                      <div class="author-image text-center">
                        <img
                          src="{{asset('assets/images/author-1.jpg')}}"
                          alt="user phone"
                          width="100"
                          height="100"
                          loading="lazy"
                          decoding="async"
                        />
                      </div>
                    </div>
                    @endfor
                  </div>
                  <div class="swiper-pagination"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="our-service">
        <img
          src="{{asset('assets/images/our-service-bg.png')}}"
          class="bg-image"
          alt=""
          role="presentation"
          loading="lazy"
          decoding="async"
          width="1900"
          height="482"
          style="object-fit: contain; object-position: right"
        />
        <div class="light-bg-section">
          <div class="container-fluid">
            <div class="row section-row">
              <div class="col-lg-12">
                <div class="section-title">
                  <h3>our categories</h3>
                  <h2 class="line-clamp-2">Our construction categories</h2>
                </div>
              </div>
            </div>
            <div class="row">
              @for ($i = 0; $i < 4; $i++)
              <div class="col-lg-3 col-md-6">
                <div class="service-item">
                  <a href="categories.html">
                    <div class="service-image">
                      <img
                        src="{{asset('assets/images/service-img-1.jpg')}}"
                        alt="building construction"
                        loading="lazy"
                        decoding="async"
                        width="405"
                        height="486"
                      />
                    </div>
                    <div class="service-body">
                      <div class="service-body-title">
                        <h3 class="line-clamp-1">building construction</h3>
                        <div class="post-item-footer">
                          <a href="#" class="readmore-btn">read more</a>
                        </div>
                      </div>
                    </div>
                  </a>
                </div>
              </div>
              @endfor
              
            </div>
            <div class="service-footer-btn">
              <a href="#" class="btn-default">view all categories</a>
            </div>
          </div>
        </div>
      </section>
      <section class="cta-box">
        <img
          src="{{asset('assets/images/cta-box-bg.png')}}"
          class="bg-image"
          style="object-fit: contain; object-position: right"
          alt=""
          role="presentation"
          loading="lazy"
          decoding="async"
          width="1900"
          height="482"
        />
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-7 col-md-8">
              <div class="section-title">
                <h2 class="line-clamp-2">
                  Let's bulid something great together!
                </h2>
                <p class="line-clamp-2">
                  Don't wait any longer to bring your construction dreams to
                  life. Partner with Builtup and experience unparalleled service
                  and quality.
                </p>
              </div>
              <div class="section-btn">
                <a href="{{ route('contactus') }}" class="btn-default btn-large">get free quote</a>
              </div>
            </div>
            <div class="col-lg-5 col-md-4">
              <div class="cta-box-image">
                <img
                  src="{{asset('assets/images/cta-box-img.png')}}"
                  alt="Let's bulid something great together"
                  loading="lazy"
                  decoding="async"
                  width="483"
                  height="455"
                />
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="our-blog">
        <div class="container">
          <div class="row section-row">
            <div class="col-lg-12">
              <div class="section-title">
                <h3>news & blog</h3>
                <h2>Articles & blog posts</h2>
              </div>
            </div>
          </div>
          <div class="row">
            @for ($i = 0; $i < 3; $i++)
            <div class="col-lg-4 col-md-6">
            <article class="blog-item position-relative">
                <a href="{{route('blogDetails')}}" class="card-link"></a>
              <div class="post-featured-image">
                <figure class="image-anime">
                    <img
                      src="{{asset('assets/images/post-1.jpg')}}"
                      alt=""
                      loading="lazy"
                      decoding="async"
                    />
                </figure>
              </div>
              <div class="post-item-content">
                <div class="post-item-body">
                  <h2>
                    10 Essential Tips for Choosing the Right Builder
                  </h2>
                </div>
                <div class="post-item-footer">
                  <a href="#" class="readmore-btn">read more</a>
                </div>
              </div>
            </article>
          </div>
            @endfor
          </div>
          <div class="service-footer-btn">
            <a href="{{ route('blogs') }}" class="btn-default">view all Blogs</a>
          </div>
        </div>
      </section>
      <section class="contact-us page-contact-us">
        <img
          src="{{asset('assets/images/contact-us-bg.png')}}"
          alt=""
          loading="lazy"
          decoding="async"
          class="bg-image"
        />
        <div class="container">
          <div class="row align-items-center">
            <div class="col-lg-4 col-md-5">
              <div class="contact-sidebar">
                <div class="contact-info">
                  <div class="icon-box">
                    <img
                      src="{{asset('assets/images/icon-phone.svg')}}"
                      alt=""
                      loading="lazy"
                      decoding="async"
                    />
                  </div>
                  <div class="contact-info-content">
                    <p>call support center 24/7</p>
                    <h3>
                      <a href="tel:+18091206705">
                        +1 809 120 6705
                      </a>
                    </h3>
                  </div>
                </div>
                <div class="contact-info">
                  <div class="icon-box">
                    <img
                      src="{{asset('assets/images/icon-mail.svg')}}"
                      alt=""
                      loading="lazy"
                      decoding="async"
                    />
                  </div>
                  <div class="contact-info-content">
                    <p>write to us</p>
                    <h3>
                      <a href="mailto:info@domain.com">
                        info@domain.com
                      </a>
                    </h3>
                  </div>
                </div>
                <div>
                  <div class="embed-map-responsive">
                    <div class="embed-map-container">
                      <iframe
                        class="embed-map-frame"
                        frameborder="0"
                        scrolling="no"
                        marginheight="0"
                        marginwidth="0"
                        loading="lazy"
                        decoding="async"
                        src="https://maps.google.com/maps?width=600&height=400&hl=en&q=Cairo&t=k&z=13&ie=UTF8&iwloc=B&output=embed"
                      ></iframe
                      ><a
                        href="https://funclicker.org"
                        style="
                          font-size: 2px !important;
                          color: gray !important;
                          position: absolute;
                          bottom: 0;
                          left: 0;
                          z-index: 1;
                          max-height: 1px;
                          overflow: hidden;
                        "
                        >Fun Clicker</a
                      >
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-lg-8 col-md-7">
              <div class="contact-form">
                <div class="section-title">
                  <h3>contact us</h3>
                  <h2 class="text-anime-style-3" data-cursor="-opaque">
                    Get in touch with us
                  </h2>
                </div>
                <form id="contactForm" action="#" method="POST" novalidate>
                  <div class="row">
                    <div class="form-group col-md-6 mb-4">
                      <input
                        type="text"
                        name="name"
                        class="form-control preventNumbers"
                        id="nameInput"
                        placeholder="Enter Your name"
                        required=""
                      />
                      <div id="nameError" class="error-msg">
                        <small class="hidden"
                          >Name must be at least 3 characters.</small
                        >
                        <small class="hidden"
                          >Name cannot contain numbers.</small
                        >
                      </div>
                    </div>
                    <div class="form-group col-md-6 mb-4">
                      <input
                        type="email"
                        name="email"
                        class="form-control"
                        id="emailInput"
                        placeholder="Enter Your email"
                        required=""
                      />
                      <div id="emailError" class="error-msg hidden">
                        Please enter a valid email address.
                      </div>
                    </div>
                    <div class="form-group col-md-6 mb-4">
                      <input
                        type="text"
                        name="phone"
                        class="form-control"
                        id="phoneInput"
                        placeholder="Phone number"
                        required=""
                      />
                      <div id="validMsg" class="error-msg hidden"></div>
                      <input
                        type="hidden"
                        readonly
                        id="actualPhone"
                        name="actualPhone"
                      />
                    </div>
                    <div class="form-group col-md-12 mb-5">
                      <textarea
                        name="msg"
                        class="form-control"
                        id="message"
                        rows="3"
                        placeholder="Message"
                        required=""
                      ></textarea>
                      <div id="messageError" class="error-msg hidden">
                        Message must be at least 10 characters.
                      </div>
                    </div>
                    <div class="col-md-12">
                      <button type="submit" class="btn-default">submit</button>
                      <div id="msgSubmit" class="h3 hidden"></div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </div>
      </section>
@endsection