<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\AboutHistoryController;
use App\Http\Controllers\AboutWhySectionController;
use App\Http\Controllers\AboutFeatureController;
use App\Http\Controllers\CounterController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\SocialMediaController;
use App\Http\Controllers\ClientController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ProjectSectorController;
use App\Http\Controllers\FeatureController;
use App\Http\Controllers\ProjectImageController;
use App\Http\Controllers\ProjectVideoController;
use App\Http\Controllers\CategoryController;

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\DashboardController;
    Route::get('/', function () {
        return view('frontend.home');
    })->name('home');

    Route::get('/login', function () {
        return view('auth.login');
    })->name('login');

    Route::get('/register', function () {
        return view('auth.register');
    })->name('register');


    Route::post('/login', [LoginController::class, 'login'])->name('login');
        Route::post('/register', [RegisterController::class, 'register'])->name('register');
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    Route::get('/blogs', function () {
        return view('frontend.blogs');
    })->name('blogs');
    Route::get('/blogs-details', function () {
        return view('frontend.blogDetails');
    })->name('blogDetails');
    Route::get('/contact-us', function () {
        return view('frontend.contactus');
    })->name('contactus');
    Route::get('/privacy-policy', function () {
        return view('frontend.privacyPolicy');
    })->name('privacyPolicy');
    Route::get('/products', function () {
        return view('frontend.products');
    })->name('products');
    Route::get('/product-details', function () {
        return view('frontend.productDetails');
    })->name('productDetails');

    Route::get('/about', function () {
        return view('frontend.about');
    })->name('about');
    Route::get('/categories', function () {
        return view('frontend.categories');
    })->name('categories');
    Route::get('/blogs', function () {
        return view('frontend.blogs');
    })->name('blogs');
    Route::get('/blog-details', function () {
        return view('frontend.blogDetails');
    })->name('blogDetails');

// Admin Routes
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');


    // About Us Routes
    Route::resource('about-us', AboutUsController::class);

    // About History Routes
    Route::resource('about-history', AboutHistoryController::class);

    // About Why Section Routes
    Route::resource('about-why-section', AboutWhySectionController::class);

    // About Feature Routes
    Route::resource('about-feature', AboutFeatureController::class);

    // Counter Routes
    Route::resource('counters', CounterController::class);


    // Blog Routes
    Route::resource('blogs', BlogController::class);

    // Social Media Routes
    Route::resource('social-media', SocialMediaController::class);

    // Client Routes
    Route::resource('clients', ClientController::class);

    // Project Routes
    Route::resource('projects', ProjectController::class);

    // Project Sector Routes
    Route::resource('project-sectors', ProjectSectorController::class);

    // Feature Routes
    Route::resource('features', FeatureController::class);

    // Project Image Routes
    Route::resource('project-images', ProjectImageController::class);

    // Project Video Routes
    Route::resource('project-videos', ProjectVideoController::class);


    // Category Routes
    Route::resource('categories', CategoryController::class);

    // Contact Information Routes
    Route::resource('contact-information', ContactInformationController::class);

    // Contact Form Routes
    Route::resource('contact-form', ContactFormController::class);

    // Privacy Policy Routes
    Route::resource('privacy-policy', PrivacyPolicyController::class);

    // Social Media Routes
    Route::resource('social_medias', SocialMediaController::class);

});