

<?php $__env->startSection('title', 'Lessons'); ?>         

<?php $__env->startSection('content'); ?>

    <link href="<?php echo e(asset('backend/vendor/datatables/css/jquery.dataTables.min.css')); ?>" rel="stylesheet">

    <div class="content-body">
        <div class="container-fluid">
            <div class="page-titles">
                <div class="d-flex justify-content-between align-items-center mb-3">

                    <ol class="breadcrumb mb-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
                        <li class="breadcrumb-item active">Lessons</li>
                    </ol>

                    <div class="d-flex gap-2">
                        <div class="" href="javascript:void(0)">
                            <input type="text" name="search" id="search" class="form-control" placeholder="Search">

                        </div>
                        <a class="btn btn-success" onclick="downloadExcel()">
                            <i class="fas fa-file-excel" style="font-size: 18px;"></i>
                        </a>
                        <a class="btn btn-danger" onclick="downloadPDF()">
                            <i class="fas fa-file-pdf" style="font-size: 18px;height: 20px;"></i>
                        </a>

                        <a href="<?php echo e(route('admin.lessons-create', $lessonCategory->id)); ?>" class="btn btn-primary">
                            <i class="fas fa-plus" style="font-size: 18px;"></i>
                        </a>
                    </div>

                </div>

            </div>
            <div class="row">

                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">Lessons</h4>
                        </div>
                        <div class="card-body">
                            <?php if(session('success')): ?>
                                <div class="alert alert-success">
                                    <?php echo e(session('success')); ?>

                                </div>
                            <?php endif; ?>
                            <div class="table-responsive">
                                <table id="example3"
                                    class="table table-bordered table-striped table-responsive-md table-hover table-datatable">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Title</th>
                                            <th>Status</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $lessons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lesson): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($lesson->id); ?></td>
                                                <td><?php echo e($lesson->title); ?></td>
                                                <td >
                                                    <?php if($lesson->is_active == 1): ?>
                                                        <span class="badge bg-success">Active</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger">Inactive</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.lessons-edit', $lesson->id)); ?>"
                                                        class="btn btn-sm btn-info">
                                                        <i class="fas fa-edit"></i>
                                                    </a>

                                                  

                                                    <?php if($lesson->is_active == 0): ?>
                                                        <form class="d-inline" action="<?php echo e(route('admin.lessons-activate', $lesson->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('PUT'); ?>
                                                            <button type="submit" class="btn btn-sm btn-success">
                                                                <i class="fas fa-trash-restore"></i>
                                                            </button>
                                                        </form>
                                                    <?php else: ?>
                                                        <form class="d-inline" action="<?php echo e(route('admin.lessons-destroy', $lesson->id)); ?>" method="POST">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn btn-sm btn-danger">
                                                                <i class="fas fa-trash"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($lessons->isEmpty()): ?>
                                            <tr>
                                                <td colspan="100" class="text-center">No lessons found</td>
                                            </tr>
                                        <?php endif; ?>

                                    </tbody>

                                </table>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    




    <script src="<?php echo e(asset('backend/vendor/datatables/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/plugins-init/datatables.init.js')); ?>"></script>

    <!-- For Excel -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <!-- For PDF -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script>
        // ========== DOWNLOAD EXCEL ==========
        function downloadExcel() {
            let table = document.getElementById("example3");
            let wb = XLSX.utils.table_to_book(table, {
                sheet: "Lessons"
            });
            XLSX.writeFile(wb, "lessons.xlsx");
        }

        // ========== DOWNLOAD PDF ==========
        async function downloadPDF() {
            const {
                jsPDF
            } = window.jspdf;
            let table = document.getElementById("example3");

            html2canvas(table, {
                scale: 2
            }).then(canvas => {
                let imgData = canvas.toDataURL("image/png");
                let pdf = new jsPDF('l', 'mm', 'a4');

                let pageWidth = pdf.internal.pageSize.getWidth();
                let pageHeight = pdf.internal.pageSize.getHeight();

                let imgWidth = pageWidth - 20;
                let imgHeight = (canvas.height * imgWidth) / canvas.width;

                let position = 10;

                if (imgHeight < pageHeight) {
                    pdf.addImage(imgData, 'PNG', 10, position, imgWidth, imgHeight);
                } else {
                    let y = 0;
                    while (y < imgHeight) {
                        pdf.addImage(imgData, 'PNG', 10, position - y, imgWidth, imgHeight);
                        y += pageHeight;
                        if (y < imgHeight) pdf.addPage();
                    }
                }

                pdf.save("lesson-categories.pdf");
            });
        }
    </script>

    <script>
        document.getElementById("search").addEventListener("keyup", function () {
            let value = this.value.toLowerCase();
            let rows = document.querySelectorAll("#example3 tbody tr");
        
            rows.forEach(row => {
                let text = row.innerText.toLowerCase();
                row.style.display = text.includes(value) ? "" : "none";
            });
        });
    </script>

    <script>
        document.querySelectorAll("#example3 th").forEach((header, index) => {
            header.style.cursor = "pointer";
            header.addEventListener("click", function () {
                sortTable(index);
            });
        });
        
        function sortTable(columnIndex) {
            const table = document.getElementById("example3");
            const tbody = table.tBodies[0];
            const rows = Array.from(tbody.querySelectorAll("tr"));
            const asc = table.getAttribute("data-sort") !== "asc";
        
            rows.sort((a, b) => {
                let x = a.children[columnIndex].innerText.trim().toLowerCase();
                let y = b.children[columnIndex].innerText.trim().toLowerCase();
        
                // لو العمود أرقام (ID – Phone – Trips)
                if (!isNaN(x) && !isNaN(y)) {
                    return asc ? x - y : y - x;
                }
        
                // لو نصوص (Name – Status)
                return asc ? x.localeCompare(y) : y.localeCompare(x);
            });
        
            rows.forEach(row => tbody.appendChild(row));
            table.setAttribute("data-sort", asc ? "asc" : "desc");
        }
    </script>
    
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\khamsaplaning\resources\views/admin/lessons/index.blade.php ENDPATH**/ ?>