

<?php $__env->startSection('title', 'Edit Blogs'); ?>

<?php $__env->startSection('content'); ?>


    <style>
        .page-titles .breadcrumb .breadcrumb-item+.breadcrumb-item::before {
            display: none;
        }


        .upload-box {
            width: 100%;
            max-width: 400px;
            margin: 20px auto;
            font-family: sans-serif;
        }

        .upload-area {
            border: 2px dashed #cbd5e1;
            border-radius: 16px;
            padding: 40px 20px;
            text-align: center;
            cursor: pointer;
            transition: 0.3s;
            position: relative;
        }

        .upload-area:hover {
            border-color: #3b82f6;
            background: #f8fafc;
        }

        .upload-placeholder i {
            font-size: 40px;
            color: #3b82f6;
            margin-bottom: 10px;
        }

        .upload-placeholder p {
            font-size: 16px;
            font-weight: 600;
            margin: 0;
        }

        .upload-placeholder span {
            font-size: 12px;
            color: #6b7280;
        }

        .preview-img {
            width: 100%;
            height: 250px;
            object-fit: cover;
            border-radius: 12px;
            display: none;
        }

        .upload-actions {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-top: 10px;
        }

        .upload-actions button {
            padding: 6px 16px;
            border-radius: 8px;
            border: none;
            cursor: pointer;
            font-size: 14px;
        }

        .btn-change {
            background: #3b82f6;
            color: white;
        }

        .btn-remove {
            background: #ef4444;
            color: white;
        }
    </style>

    <div class="content-body">
        <div class="container-fluid">

            <div class="row page-titles">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard | </a></li>
                    <li class="breadcrumb-item active"><a href="<?php echo e(route('admin.blogs.index')); ?>">Blogs > </a></li>
                    <li class="breadcrumb-item "><a href="javascript:void(0)">Edit</a></li>
                </ol>
            </div>


            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">

                                <div class="col-lg-12">
                                    <div class="">
                                        <?php if(session('success')): ?>
                                            <div class="alert alert-success">
                                                <?php echo e(session('success')); ?>

                                            </div>
                                        <?php endif; ?>

                                        <div class="compose-content">
                                            <form action="<?php echo e(route('admin.blogs.update', $row->id)); ?>" method="POST"
                                                enctype="multipart/form-data">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PUT'); ?>


                                                <div class="mb-3">
                                                    <label for="title">Title</label>
                                                    <input type="text" class="form-control bg-transparent" name="title"
                                                        value="<?php echo e($row->title); ?>">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="description">Description</label>
                                                    <textarea class="form-control bg-transparent ckeditor" data-editor="description" name="description" rows="3"
                                                        placeholder="Description:"><?php echo e($row->description); ?></textarea>
                                                </div>

                                                <div class="mb-3">
                                                    <label for="meta_title">Meta Title</label>
                                                    <input type="text" class="form-control bg-transparent" name="meta_title"
                                                        value="<?php echo e($row->meta_title); ?>">
                                                </div>

                                                <div class="mb-3">
                                                    <label for="meta_description">Meta Description</label>
                                                    <textarea class="form-control bg-transparent" name="meta_description" rows="3" placeholder="Meta Description:"><?php echo e($row->meta_description); ?></textarea>
                                                </div>

                                                <div class="mb-3">
                                                    <label for="page_schema">Page Schema</label>
                                                    <textarea class="form-control bg-transparent" name="page_schema" rows="3" placeholder="Page Schema:"><?php echo e($row->page_schema); ?></textarea>
                                                </div>

                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i>Current Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">

                                                        <div class="upload-area" style="cursor: default;">

                                                            <?php if($row->image): ?>
                                                                <img id="" width="200" class=""
                                                                    src="<?php echo e(asset('/' . $row->image)); ?>" />
                                                            <?php else: ?>
                                                                <img id="" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="<?php echo e(asset('backend/images/Anonymous 2.png')); ?>" />
                                                            <?php endif; ?>
                                                        </div>



                                                    </div>

                                                </div>


                                                <h5 class="mb-4"><i class="fa fa-paperclip"></i> Main Image</h5>
                                                <div class="fallback">
                                                    <div class="upload-box">
                                                        <input type="file" name="image" id="imageInput"
                                                            accept="image/*" hidden>

                                                        <div class="upload-area" style="cursor: pointer;"
                                                            onclick="document.getElementById('imageInput').click()">
                                                            <div class="upload-placeholder" id="placeholder">
                                                                <i class="fa fa-cloud-upload"></i>
                                                                <p>Click to upload image</p>
                                                                <span>PNG, JPG up to 5MB</span>
                                                            </div>

                                                            <?php if($row->image): ?>
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="<?php echo e($row->image); ?>" />
                                                            <?php else: ?>
                                                                <img id="previewImage" width="100px" height="100px"
                                                                    class="preview-img"
                                                                    src="<?php echo e(asset('backend/images/Anonymous 2.png')); ?>" />
                                                            <?php endif; ?>
                                                        </div>

                                                        <div class="upload-actions" id="actions" style="display:none">
                                                            <button type="button" class="btn-change"
                                                                onclick="changeImage()">Change</button>
                                                            <button type="button" class="btn-remove"
                                                                onclick="removeImage()">Remove</button>
                                                        </div>


                                                    </div>

                                                </div>

                                                <div class="mb-3">
                                                    <label for="is_active">Is Active</label>
                                                    <select class="form-control bg-transparent" name="is_active">
                                                        <option value="1" <?php echo e($row->is_active == 1 ? 'selected' : ''); ?>>Yes</option>
                                                        <option value="0" <?php echo e($row->is_active == 0 ? 'selected' : ''); ?>>No</option>
                                                    </select>
                                                </div>


                                                <div class="text-start mt-4 mb-3">
                                                    <button class="btn btn-primary btn-sl-sm me-2" type="submit"><span
                                                            class="me-2"><i
                                                                class="fa fa-paper-plane"></i></span>Submit</button>

                                                    <a href="<?php echo e(route('admin.blogs.index')); ?>"
                                                        class="btn btn-danger light btn-sl-sm">
                                                        <span class="me-2"><i class="fa fa-times"></i></span>Discard
                                                    </a>
                                                </div>
                                            </form>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    <script>
        const input = document.getElementById('imageInput');
        const preview = document.getElementById('previewImage');
        const placeholder = document.getElementById('placeholder');
        const actions = document.getElementById('actions');

        input.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                    placeholder.style.display = 'none';
                    actions.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImage() {
            input.click();
        }

        function removeImage() {
            input.value = '';
            preview.src = '';
            preview.style.display = 'none';
            placeholder.style.display = 'block';
            actions.style.display = 'none';
        }
    </script>

    <script>
        const inputEN = document.getElementById('imageInputEN');
        const previewEN = document.getElementById('previewImageEN');
        const placeholderEN = document.getElementById('placeholderEN');
        const actionsEN = document.getElementById('actionsEN');

        inputEN.addEventListener('change', function() {
            const file = this.files[0];

            if (file) {
                const reader = new FileReader();

                reader.onload = function(e) {
                    previewEN.src = e.target.result;
                    previewEN.style.display = 'block';
                    placeholderEN.style.display = 'none';
                    actionsEN.style.display = 'flex';
                }

                reader.readAsDataURL(file);
            }
        });

        function changeImageEN() {
            inputEN.click();
        }

        function removeImageEN() {
            inputEN.value = '';
            previewEN.src = '';
            previewEN.style.display = 'none';
            placeholderEN.style.display = 'block';
            actionsEN.style.display = 'none';
        }
    </script>

<script>
    const inputMessage = document.getElementById('imageInputMessage');
    const previewMessage = document.getElementById('previewImageMessage');
    const placeholderMessage = document.getElementById('placeholderMessage');
    const actionsMessage = document.getElementById('actionsMessage');

    inputMessage.addEventListener('change', function() {
        const file = this.files[0];

        if (file) {
            const reader = new FileReader();

            reader.onload = function(e) {
                previewMessage.src = e.target.result;
                previewMessage.style.display = 'block';
                placeholderMessage.style.display = 'none';
                actionsMessage.style.display = 'flex';
            }

            reader.readAsDataURL(file);
        }
    });

    function changeImageMessage() {
        inputMessage.click();
    }

    function removeImageMessage() {
        inputMessage.value = '';
        previewMessage.src = '';
        previewMessage.style.display = 'none';
        placeholderMessage.style.display = 'block';
        actionsMessage.style.display = 'none';
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\khamsaplaning\resources\views/admin/blog/edit.blade.php ENDPATH**/ ?>