<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['name', 'label', 'currentImage' => null, 'accept' => 'image/*']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['name', 'label', 'currentImage' => null, 'accept' => 'image/*']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<div class="mb-4">
    <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2"><?php echo e($label); ?></label>
    
    <div class="image-upload-container" data-name="<?php echo e($name); ?>">
        <input type="file" 
               name="<?php echo e($name); ?>" 
               id="<?php echo e($name); ?>" 
               accept="<?php echo e($accept); ?>"
               class="hidden image-input"
               onchange="handleImageUpload(this)">
        
        <div class="border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg p-6 text-center hover:border-blue-500 transition-colors cursor-pointer image-upload-area"
             onclick="document.getElementById('<?php echo e($name); ?>').click()">
            <?php if($currentImage): ?>
                <div class="relative inline-block">
                    <img src="<?php echo e(Storage::url($currentImage)); ?>" 
                         alt="Preview" 
                         class="max-h-64 mx-auto rounded-lg shadow-lg image-preview">
                    <div class="absolute top-2 right-2 bg-red-500 text-white rounded-full w-8 h-8 flex items-center justify-center cursor-pointer hover:bg-red-600"
                         onclick="event.stopPropagation(); removeImage(this)">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </div>
                </div>
                <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">Click to change image</p>
            <?php else: ?>
                <div class="image-placeholder">
                    <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                        <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                    <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">Click to upload or drag and drop</p>
                    <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">PNG, JPG, GIF up to 10MB</p>
                </div>
            <?php endif; ?>
        </div>
        
        <div class="upload-progress hidden mt-2">
            <div class="flex items-center justify-between mb-1">
                <span class="text-sm text-gray-600 dark:text-gray-400">Uploading...</span>
                <button type="button" class="text-sm text-red-600 hover:text-red-800" onclick="cancelUpload(this)">tap to cancel</button>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2">
                <div class="bg-blue-600 h-2 rounded-full progress-bar" style="width: 0%"></div>
            </div>
        </div>
    </div>
    
    <?php $__errorArgs = [$name];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

<script>
function handleImageUpload(input) {
    const container = input.closest('.image-upload-container');
    const uploadArea = container.querySelector('.image-upload-area');
    const placeholder = container.querySelector('.image-placeholder');
    const progressDiv = container.querySelector('.upload-progress');
    const progressBar = container.querySelector('.progress-bar');
    const preview = container.querySelector('.image-preview');
    
    if (input.files && input.files[0]) {
        const file = input.files[0];
        const reader = new FileReader();
        
        // Show progress
        progressDiv.classList.remove('hidden');
        progressBar.style.width = '0%';
        
        // Simulate upload progress
        let progress = 0;
        const interval = setInterval(() => {
            progress += 10;
            progressBar.style.width = progress + '%';
            if (progress >= 90) {
                clearInterval(interval);
            }
        }, 100);
        
        reader.onload = function(e) {
            // Hide placeholder
            if (placeholder) {
                placeholder.style.display = 'none';
            }
            
            // Create or update preview
            if (!preview) {
                const img = document.createElement('img');
                img.src = e.target.result;
                img.className = 'max-h-64 mx-auto rounded-lg shadow-lg image-preview';
                uploadArea.innerHTML = '';
                uploadArea.appendChild(img);
                
                // Add remove button
                const removeBtn = document.createElement('div');
                removeBtn.className = 'absolute top-2 right-2 bg-red-500 text-white rounded-full w-8 h-8 flex items-center justify-center cursor-pointer hover:bg-red-600';
                removeBtn.innerHTML = '<svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>';
                removeBtn.onclick = (e) => {
                    e.stopPropagation();
                    removeImage(removeBtn);
                };
                uploadArea.style.position = 'relative';
                uploadArea.appendChild(removeBtn);
            } else {
                preview.src = e.target.result;
            }
            
            // Complete progress
            clearInterval(interval);
            progressBar.style.width = '100%';
            setTimeout(() => {
                progressDiv.classList.add('hidden');
            }, 500);
        };
        
        reader.readAsDataURL(file);
    }
}

function removeImage(button) {
    const container = button.closest('.image-upload-container');
    const input = container.querySelector('.image-input');
    const uploadArea = container.querySelector('.image-upload-area');
    const placeholder = container.querySelector('.image-placeholder');
    
    input.value = '';
    
    // Restore placeholder
    if (!placeholder) {
        uploadArea.innerHTML = `
            <div class="image-placeholder">
                <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                    <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
                <p class="mt-2 text-sm text-gray-600 dark:text-gray-400">Click to upload or drag and drop</p>
                <p class="text-xs text-gray-500 dark:text-gray-500 mt-1">PNG, JPG, GIF up to 10MB</p>
            </div>
        `;
    } else {
        placeholder.style.display = 'block';
    }
}

function cancelUpload(button) {
    const container = button.closest('.image-upload-container');
    const input = container.querySelector('.image-input');
    const progressDiv = container.querySelector('.upload-progress');
    
    input.value = '';
    progressDiv.classList.add('hidden');
}

// Drag and drop support
document.addEventListener('DOMContentLoaded', function() {
    const uploadAreas = document.querySelectorAll('.image-upload-area');
    uploadAreas.forEach(area => {
        area.addEventListener('dragover', function(e) {
            e.preventDefault();
            e.stopPropagation();
            this.classList.add('border-blue-500', 'bg-blue-50');
        });
        
        area.addEventListener('dragleave', function(e) {
            e.preventDefault();
            e.stopPropagation();
            this.classList.remove('border-blue-500', 'bg-blue-50');
        });
        
        area.addEventListener('drop', function(e) {
            e.preventDefault();
            e.stopPropagation();
            this.classList.remove('border-blue-500', 'bg-blue-50');
            
            const files = e.dataTransfer.files;
            if (files.length > 0) {
                const input = this.closest('.image-upload-container').querySelector('.image-input');
                input.files = files;
                handleImageUpload(input);
            }
        });
    });
});
</script>

<?php /**PATH C:\xampp\htdocs\housetech\resources\views/components/image-upload.blade.php ENDPATH**/ ?>