<?php

require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$controllers = [
    'App\Http\Controllers\Admin\AboutHomeController',
    'App\Http\Controllers\Admin\BlogController',
    'App\Http\Controllers\Admin\ClientController',
    'App\Http\Controllers\Admin\ContactFormController',
    'App\Http\Controllers\Admin\ContactInformationController',
    'App\Http\Controllers\Admin\CounterController',
    'App\Http\Controllers\Admin\CourseController',
    'App\Http\Controllers\Admin\CourseCategoryController',
    'App\Http\Controllers\Admin\CourseFormController',
    'App\Http\Controllers\Admin\DashboardController',
    'App\Http\Controllers\Admin\FeatureController',
    'App\Http\Controllers\Admin\FeatureSectionController',
    'App\Http\Controllers\Admin\HeroSectionController',
    'App\Http\Controllers\Admin\LessonCategoryController',
    'App\Http\Controllers\Admin\LessonController',
    'App\Http\Controllers\Admin\PageInformationController',
    'App\Http\Controllers\Admin\PartnerController',
    'App\Http\Controllers\Admin\PrivacyPolicyController',
    'App\Http\Controllers\Admin\SocialMediaController',
    'App\Http\Controllers\Admin\TestimonialController',
    'App\Http\Controllers\Admin\UserController',
    'App\Http\Controllers\Admin\UserCourseProgressController',
];

$failed = [];
$passed = [];

foreach ($controllers as $controller) {
    try {
        if (!class_exists($controller)) {
            $failed[] = "$controller does not exist.";
            continue;
        }

        $instance = app($controller);
        $passed[] = "$controller instantiated successfully.";
    } catch (\Exception $e) {
        $failed[] = "$controller failed to instantiate: " . $e->getMessage();
    }
}

echo "Verification Results:\n";
echo "=====================\n";
echo "Passed: " . count($passed) . "\n";
echo "Failed: " . count($failed) . "\n\n";

if (!empty($failed)) {
    echo "Failures:\n";
    foreach ($failed as $fail) {
        echo "- $fail\n";
    }
    exit(1);
} else {
    echo "All controllers verified successfully.\n";
    exit(0);
}
